/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator byteBufAllocator, ByteOrder byteOrder) {
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        this.alloc = byteBufAllocator;
        this.order = byteOrder;
        this.str = StringUtil.simpleClassName(this) + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public final int capacity() {
        return 0;
    }

    @Override
    public final ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final int maxCapacity() {
        return 0;
    }

    @Override
    public final ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == ((ByteBuf)this).order()) {
            return this;
        }
        EmptyByteBuf emptyByteBuf = this.swapped;
        if (emptyByteBuf != null) {
            return emptyByteBuf;
        }
        this.swapped = emptyByteBuf = new EmptyByteBuf(((ByteBuf)this).alloc(), byteOrder);
        return emptyByteBuf;
    }

    @Override
    public final int readerIndex() {
        return 0;
    }

    @Override
    public final ByteBuf readerIndex(int n2) {
        return this.checkIndex(n2);
    }

    @Override
    public final int writerIndex() {
        return 0;
    }

    @Override
    public final ByteBuf writerIndex(int n2) {
        return this.checkIndex(n2);
    }

    @Override
    public final ByteBuf setIndex(int n2, int n3) {
        this.checkIndex(n2);
        this.checkIndex(n3);
        return this;
    }

    @Override
    public final int readableBytes() {
        return 0;
    }

    @Override
    public final int writableBytes() {
        return 0;
    }

    @Override
    public final int maxWritableBytes() {
        return 0;
    }

    @Override
    public final boolean isReadable() {
        return false;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final ByteBuf clear() {
        return this;
    }

    @Override
    public final ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf markWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        return this;
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        return this;
    }

    @Override
    public final ByteBuf ensureWritable(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minWritableBytes: " + n2 + " (expected: >= 0)");
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final int ensureWritable(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minWritableBytes: " + n2 + " (expected: >= 0)");
        }
        if (n2 == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public final boolean getBoolean(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte getByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getUnsignedByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getUnsignedInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getLong(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char getChar(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float getFloat(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double getDouble(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        return this.checkIndex(n2, byteBuf.writableBytes());
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray) {
        return this.checkIndex(n2, byArray.length);
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public final ByteBuf setBoolean(int n2, boolean bl) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setByte(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setShort(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setMedium(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setInt(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setLong(int n2, long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setChar(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setFloat(int n2, float f2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setDouble(int n2, double d2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray) {
        return this.checkIndex(n2, byArray.length);
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public final ByteBuf setZero(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final boolean readBoolean() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char readChar() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float readFloat() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double readDouble() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf readBytes(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf readSlice(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.writableBytes());
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public final ByteBuf skipBytes(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf writeBoolean(boolean bl) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeLong(long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeChar(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeFloat(float f2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeDouble(double d2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public final int writeBytes(InputStream inputStream, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public final ByteBuf writeZero(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final int indexOf(int n2, int n3, byte by) {
        this.checkIndex(n2);
        this.checkIndex(n3);
        return -1;
    }

    @Override
    public final int bytesBefore(byte by) {
        return -1;
    }

    @Override
    public final int bytesBefore(int n2, byte by) {
        this.checkLength(n2);
        return -1;
    }

    @Override
    public final int bytesBefore(int n2, int n3, byte by) {
        this.checkIndex(n2, n3);
        return -1;
    }

    @Override
    public final int forEachByte(ByteBufProcessor byteBufProcessor) {
        return -1;
    }

    @Override
    public final int forEachByte(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        this.checkIndex(n2, n3);
        return -1;
    }

    @Override
    public final int forEachByteDesc(ByteBufProcessor byteBufProcessor) {
        return -1;
    }

    @Override
    public final int forEachByteDesc(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        this.checkIndex(n2, n3);
        return -1;
    }

    @Override
    public final ByteBuf copy() {
        return this;
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final ByteBuf slice() {
        return this;
    }

    @Override
    public final ByteBuf slice(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public final ByteBuf duplicate() {
        return this;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuf)this).nioBuffer();
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuf)this).nioBuffers();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public final int arrayOffset() {
        return 0;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public final long memoryAddress() {
        if (((ByteBuf)this).hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString(Charset charset) {
        return "";
    }

    @Override
    public final String toString(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return ((ByteBuf)this).toString(charset);
    }

    @Override
    public final int hashCode() {
        return 0;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof ByteBuf && !((ByteBuf)object).isReadable();
    }

    @Override
    public final int compareTo(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final String toString() {
        return this.str;
    }

    @Override
    public final boolean isReadable(int n2) {
        return false;
    }

    @Override
    public final boolean isWritable(int n2) {
        return false;
    }

    @Override
    public final int refCnt() {
        return 1;
    }

    @Override
    public final ByteBuf retain() {
        return this;
    }

    @Override
    public final ByteBuf retain(int n2) {
        return this;
    }

    @Override
    public final boolean release() {
        return false;
    }

    @Override
    public final boolean release(int n2) {
        return false;
    }

    private ByteBuf checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("length: " + n3);
        }
        if (n2 != 0 || n3 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length: " + n2 + " (expected: >= 0)");
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long l2 = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                l2 = PlatformDependent.directBufferAddress(EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {}
        EMPTY_BYTE_BUFFER_ADDRESS = l2;
    }
}

