/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.FixedCompositeByteBuf$Component;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final Object[] buffers;
    private final boolean direct;

    FixedCompositeByteBuf(ByteBufAllocator byteBufAllocator, ByteBuf ... byteBufArray) {
        super(Integer.MAX_VALUE);
        if (byteBufArray.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = false;
        } else {
            ByteBuf byteBuf = byteBufArray[0];
            this.buffers = new Object[byteBufArray.length];
            this.buffers[0] = byteBuf;
            boolean bl = true;
            int n2 = byteBuf.nioBufferCount();
            int n3 = byteBuf.readableBytes();
            this.order = byteBuf.order();
            for (int i2 = 1; i2 < byteBufArray.length; ++i2) {
                byteBuf = byteBufArray[i2];
                if (byteBufArray[i2].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                n2 += byteBuf.nioBufferCount();
                n3 += byteBuf.readableBytes();
                if (!byteBuf.isDirect()) {
                    bl = false;
                }
                this.buffers[i2] = byteBuf;
            }
            this.nioBufferCount = n2;
            this.capacity = n3;
            this.direct = bl;
        }
        ((ByteBuf)this).setIndex(0, ((ByteBuf)this).capacity());
        this.allocator = byteBufAllocator;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final boolean isWritable(int n2) {
        return false;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int maxCapacity() {
        return this.capacity;
    }

    @Override
    public final ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    private FixedCompositeByteBuf$Component findComponent(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.buffers.length; ++i2) {
            boolean bl;
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = null;
            Object object = this.buffers[i2];
            if (object instanceof ByteBuf) {
                object = (ByteBuf)object;
                bl = true;
            } else {
                fixedCompositeByteBuf$Component = (FixedCompositeByteBuf$Component)object;
                object = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
                bl = false;
            }
            if (n2 >= (n3 += ((ByteBuf)object).readableBytes())) continue;
            if (bl) {
                fixedCompositeByteBuf$Component = new FixedCompositeByteBuf$Component(i2, n3 - ((ByteBuf)object).readableBytes(), (ByteBuf)object);
                this.buffers[i2] = fixedCompositeByteBuf$Component;
            }
            return fixedCompositeByteBuf$Component;
        }
        throw new IllegalStateException();
    }

    private ByteBuf buffer(int n2) {
        Object object = this.buffers[n2];
        if (object instanceof ByteBuf) {
            return (ByteBuf)object;
        }
        return FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
    }

    @Override
    public final byte getByte(int n2) {
        return this._getByte(n2);
    }

    @Override
    protected final byte _getByte(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getByte(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
    }

    @Override
    protected final short _getShort(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 2 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getShort(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
        }
        return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 3 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getUnsignedMedium(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected final int _getInt(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 4 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getInt(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 16 | this._getShort(n2 + 2) & 0xFFFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getShort(n2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected final long _getLong(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 8 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getLong(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n2) & 0xFFFFFFFFL | ((long)this._getInt(n2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        Object object = this.findComponent(n2);
        int n5 = FixedCompositeByteBuf$Component.access$300((FixedCompositeByteBuf$Component)object);
        int n6 = FixedCompositeByteBuf$Component.access$100((FixedCompositeByteBuf$Component)object);
        object = FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
        while (true) {
            int n7 = Math.min(n4, ((ByteBuf)object).readableBytes() - (n2 - n6));
            ((ByteBuf)object).getBytes(n2 - n6, byArray, n3, n7);
            n2 += n7;
            n3 += n7;
            n6 += ((ByteBuf)object).readableBytes();
            if ((n4 -= n7) <= 0) break;
            object = this.buffer(++n5);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        try {
            Object object = this.findComponent(n2);
            int n5 = FixedCompositeByteBuf$Component.access$300((FixedCompositeByteBuf$Component)object);
            int n6 = FixedCompositeByteBuf$Component.access$100((FixedCompositeByteBuf$Component)object);
            object = FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
            while (true) {
                int n7 = Math.min(n4, ((ByteBuf)object).readableBytes() - (n2 - n6));
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n7);
                ((ByteBuf)object).getBytes(n2 - n6, byteBuffer);
                n2 += n7;
                n6 += ((ByteBuf)object).readableBytes();
                if ((n4 -= n7) > 0) {
                    object = this.buffer(++n5);
                    continue;
                }
                break;
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        Object object = this.findComponent(n2);
        int n5 = FixedCompositeByteBuf$Component.access$300((FixedCompositeByteBuf$Component)object);
        int n6 = FixedCompositeByteBuf$Component.access$100((FixedCompositeByteBuf$Component)object);
        object = FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
        while (true) {
            int n7 = Math.min(n4, ((ByteBuf)object).readableBytes() - (n2 - n6));
            ((ByteBuf)object).getBytes(n2 - n6, byteBuf, n3, n7);
            n2 += n7;
            n3 += n7;
            n6 += ((ByteBuf)object).readableBytes();
            if ((n4 -= n7) <= 0) break;
            object = this.buffer(++n5);
        }
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        int n4 = ((ByteBuf)this).nioBufferCount();
        if (n4 == 1) {
            return gatheringByteChannel.write(((ByteBuf)this).internalNioBuffer(n2, n3));
        }
        long l2 = gatheringByteChannel.write(((ByteBuf)this).nioBuffers(n2, n3));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return this;
        }
        Object object = this.findComponent(n2);
        int n4 = FixedCompositeByteBuf$Component.access$300((FixedCompositeByteBuf$Component)object);
        int n5 = FixedCompositeByteBuf$Component.access$100((FixedCompositeByteBuf$Component)object);
        object = FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
        while (true) {
            int n6 = Math.min(n3, ((ByteBuf)object).readableBytes() - (n2 - n5));
            ((ByteBuf)object).getBytes(n2 - n5, outputStream, n6);
            n2 += n6;
            n5 += ((ByteBuf)object).readableBytes();
            if ((n3 -= n6) <= 0) break;
            object = this.buffer(++n4);
        }
        return this;
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        boolean bl = true;
        ByteBuf byteBuf = ((ByteBuf)this).alloc().buffer(n3);
        try {
            byteBuf.writeBytes(this, n2, n3);
            bl = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    @Override
    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        Comparable<ByteBuf> comparable;
        this.checkIndex(n2, n3);
        if (this.buffers.length == 1 && ((ByteBuf)(comparable = this.buffer(0))).nioBufferCount() == 1) {
            return ((ByteBuf)comparable).nioBuffer(n2, n3);
        }
        comparable = ByteBuffer.allocate(n3).order(((ByteBuf)this).order());
        ByteBuffer[] byteBufferArray = ((ByteBuf)this).nioBuffers(n2, n3);
        for (n3 = 0; n3 < byteBufferArray.length; ++n3) {
            ((ByteBuffer)comparable).put(byteBufferArray[n3]);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        if (this.buffers.length == 1) {
            return this.buffer(0).internalNioBuffer(n2, n3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.buffers.length);
        try {
            Object object = this.findComponent(n2);
            int n4 = FixedCompositeByteBuf$Component.access$300((FixedCompositeByteBuf$Component)object);
            int n5 = FixedCompositeByteBuf$Component.access$100((FixedCompositeByteBuf$Component)object);
            object = FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
            while (true) {
                int n6 = Math.min(n3, ((ByteBuf)object).readableBytes() - (n2 - n5));
                switch (((ByteBuf)object).nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(((ByteBuf)object).nioBuffer(n2 - n5, n6));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, ((ByteBuf)object).nioBuffers(n2 - n5, n6));
                    }
                }
                n2 += n6;
                n5 += ((ByteBuf)object).readableBytes();
                if ((n3 -= n6) <= 0) break;
                object = this.buffer(++n4);
            }
            RecyclableArrayList recyclableArrayList2 = recyclableArrayList;
            ByteBuffer[] byteBufferArray = recyclableArrayList2.toArray(new ByteBuffer[recyclableArrayList2.size()]);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void deallocate() {
        for (int i2 = 0; i2 < this.buffers.length; ++i2) {
            this.buffer(i2).release();
        }
    }

    @Override
    public final String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.buffers.length + ')';
    }
}

