/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.PoolArena;
import com.aliyun.openservices.shade.io.netty.buffer.PoolChunk;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.PooledDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class PoolArena$DirectArena
extends PoolArena<ByteBuffer> {
    PoolArena$DirectArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5) {
        super(pooledByteBufAllocator, n2, n3, n4, n5);
    }

    @Override
    final boolean isDirect() {
        return true;
    }

    @Override
    protected final PoolChunk<ByteBuffer> newChunk(int n2, int n3, int n4, int n5) {
        return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n5), n2, n3, n4, n5);
    }

    @Override
    protected final PoolChunk<ByteBuffer> newUnpooledChunk(int n2) {
        return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n2), n2);
    }

    private static ByteBuffer allocateDirect(int n2) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return PlatformDependent.allocateDirectNoCleaner(n2);
        }
        return ByteBuffer.allocateDirect(n2);
    }

    @Override
    protected final void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            PlatformDependent.freeDirectNoCleaner((ByteBuffer)poolChunk.memory);
            return;
        }
        PlatformDependent.freeDirectBuffer((ByteBuffer)poolChunk.memory);
    }

    @Override
    protected final PooledByteBuf<ByteBuffer> newByteBuf(int n2) {
        if (HAS_UNSAFE) {
            return PooledUnsafeDirectByteBuf.newInstance(n2);
        }
        return PooledDirectByteBuf.newInstance(n2);
    }

    @Override
    protected final void memoryCopy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        if (HAS_UNSAFE) {
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n2, PlatformDependent.directBufferAddress(byteBuffer2) + (long)n3, n4);
            return;
        }
        byteBuffer = byteBuffer.duplicate();
        byteBuffer2 = byteBuffer2.duplicate();
        byteBuffer.position(n2).limit(n2 + n4);
        byteBuffer2.position(n3);
        byteBuffer2.put(byteBuffer);
    }
}

