/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.PoolArena;
import com.aliyun.openservices.shade.io.netty.buffer.PoolChunkList;
import com.aliyun.openservices.shade.io.netty.buffer.PoolChunkMetric;
import com.aliyun.openservices.shade.io.netty.buffer.PoolSubpage;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBuf;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final PoolArena<T> arena;
    final T memory;
    final boolean unpooled;
    private final byte[] memoryMap;
    private final byte[] depthMap;
    private final PoolSubpage<T>[] subpages;
    private final int subpageOverflowMask;
    private final int pageSize;
    private final int pageShifts;
    private final int maxOrder;
    private final int chunkSize;
    private final int log2ChunkSize;
    private final int maxSubpageAllocs;
    private final byte unusable;
    private int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> poolArena, T t2, int n2, int n3, int n4, int n5) {
        this.unpooled = false;
        this.arena = poolArena;
        this.memory = t2;
        this.pageSize = n2;
        this.pageShifts = n4;
        this.maxOrder = n3;
        this.chunkSize = n5;
        this.unusable = (byte)(n3 + 1);
        this.log2ChunkSize = PoolChunk.log2(n5);
        this.subpageOverflowMask = ~(n2 - 1);
        this.freeBytes = n5;
        assert (n3 < 30) : "maxOrder should be < 30, but is: " + n3;
        this.maxSubpageAllocs = 1 << n3;
        this.memoryMap = new byte[this.maxSubpageAllocs << 1];
        this.depthMap = new byte[this.memoryMap.length];
        int n6 = 1;
        for (int i2 = 0; i2 <= n3; ++i2) {
            n2 = 1 << i2;
            for (n4 = 0; n4 < n2; ++n4) {
                this.memoryMap[n6] = (byte)i2;
                this.depthMap[n6] = (byte)i2;
                ++n6;
            }
        }
        this.subpages = this.newSubpageArray(this.maxSubpageAllocs);
    }

    PoolChunk(PoolArena<T> poolArena, T t2, int n2) {
        this.unpooled = true;
        this.arena = poolArena;
        this.memory = t2;
        this.memoryMap = null;
        this.depthMap = null;
        this.subpages = null;
        this.subpageOverflowMask = 0;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.maxOrder = 0;
        this.unusable = (byte)(this.maxOrder + 1);
        this.chunkSize = n2;
        this.log2ChunkSize = PoolChunk.log2(this.chunkSize);
        this.maxSubpageAllocs = 0;
    }

    private PoolSubpage<T>[] newSubpageArray(int n2) {
        return new PoolSubpage[n2];
    }

    @Override
    public final int usage() {
        int n2 = this.freeBytes;
        if (n2 == 0) {
            return 100;
        }
        if ((n2 = (int)((long)n2 * 100L / (long)this.chunkSize)) == 0) {
            return 99;
        }
        return 100 - n2;
    }

    final long allocate(int n2) {
        if ((n2 & this.subpageOverflowMask) != 0) {
            return this.allocateRun(n2);
        }
        return this.allocateSubpage(n2);
    }

    private void updateParentsAlloc(int n2) {
        while (n2 > 1) {
            int n3 = n2 >>> 1;
            int n4 = this.value(n2);
            n2 = n4 < (n2 = (int)this.value(n2 ^ 1)) ? n4 : n2;
            this.setValue(n3, (byte)n2);
            n2 = n3;
        }
    }

    private void updateParentsFree(int n2) {
        int n3 = this.depth(n2) + 1;
        while (n2 > 1) {
            int n4 = n2 >>> 1;
            int n5 = this.value(n2);
            n2 = this.value(n2 ^ 1);
            if (n5 == --n3 && n2 == n3) {
                this.setValue(n4, (byte)(n3 - 1));
            } else {
                n2 = n5 < n2 ? n5 : n2;
                this.setValue(n4, (byte)n2);
            }
            n2 = n4;
        }
    }

    private int allocateNode(int n2) {
        int n3 = 1;
        int n4 = -(1 << n2);
        byte by = this.value(1);
        if (by > n2) {
            return -1;
        }
        while (by < n2 || (n3 & n4) == 0) {
            by = this.value(n3 <<= 1);
            if (by <= n2) continue;
            by = this.value(n3 ^= 1);
        }
        by = this.value(n3);
        assert (by == n2 && (n3 & n4) == 1 << n2) : String.format("val = %d, id & initial = %d, d = %d", by, n3 & n4, n2);
        this.setValue(n3, this.unusable);
        this.updateParentsAlloc(n3);
        return n3;
    }

    private long allocateRun(int n2) {
        n2 = this.maxOrder - (PoolChunk.log2(n2) - this.pageShifts);
        if ((n2 = this.allocateNode(n2)) < 0) {
            return n2;
        }
        this.freeBytes -= this.runLength(n2);
        return n2;
    }

    private long allocateSubpage(int n2) {
        PoolSubpage<T> poolSubpage;
        PoolSubpage<T> poolSubpage2 = poolSubpage = this.arena.findSubpagePoolHead(n2);
        synchronized (poolSubpage) {
            int n3 = this.maxOrder;
            n3 = this.allocateNode(n3);
            if (n3 < 0) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return n3;
            }
            PoolSubpage<T>[] poolSubpageArray = this.subpages;
            int n4 = this.pageSize;
            this.freeBytes -= n4;
            int n5 = this.subpageIdx(n3);
            PoolSubpage<T> poolSubpage3 = poolSubpageArray[n5];
            if (poolSubpage3 == null) {
                poolSubpage3 = new PoolSubpage<T>(poolSubpage, this, n3, this.runOffset(n3), n4, n2);
                poolSubpageArray[n5] = poolSubpage3;
            } else {
                poolSubpage3.init(poolSubpage, n2);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return poolSubpage3.allocate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void free(long l2) {
        int n2 = PoolChunk.memoryMapIdx(l2);
        int n3 = PoolChunk.bitmapIdx(l2);
        if (n3 != 0) {
            PoolSubpage<T> poolSubpage;
            PoolSubpage<T> poolSubpage2 = this.subpages[this.subpageIdx(n2)];
            if (!$assertionsDisabled) {
                if (poolSubpage2 == null) throw new AssertionError();
                if (!poolSubpage2.doNotDestroy) {
                    throw new AssertionError();
                }
            }
            PoolSubpage<T> poolSubpage3 = poolSubpage = this.arena.findSubpagePoolHead(poolSubpage2.elemSize);
            // MONITORENTER : poolSubpage
            if (poolSubpage2.free(poolSubpage, n3 & 0x3FFFFFFF)) {
                // MONITOREXIT : poolSubpage3
                return;
            }
            // MONITOREXIT : poolSubpage3
        }
        this.freeBytes += this.runLength(n2);
        this.setValue(n2, this.depth(n2));
        this.updateParentsFree(n2);
    }

    final void initBuf(PooledByteBuf<T> pooledByteBuf, long l2, int n2) {
        int n3 = PoolChunk.memoryMapIdx(l2);
        int n4 = PoolChunk.bitmapIdx(l2);
        if (n4 == 0) {
            n4 = this.value(n3);
            assert (n4 == this.unusable) : String.valueOf(n4);
            pooledByteBuf.init(this, l2, this.runOffset(n3), n2, this.runLength(n3), this.arena.parent.threadCache());
            return;
        }
        this.initBufWithSubpage(pooledByteBuf, l2, n4, n2);
    }

    final void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, long l2, int n2) {
        long l3 = l2;
        this.initBufWithSubpage(pooledByteBuf, l3, PoolChunk.bitmapIdx(l3), n2);
    }

    private void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, long l2, int n2, int n3) {
        assert (n2 != 0);
        int n4 = PoolChunk.memoryMapIdx(l2);
        PoolSubpage<T> poolSubpage = this.subpages[this.subpageIdx(n4)];
        assert (poolSubpage.doNotDestroy);
        assert (n3 <= poolSubpage.elemSize);
        pooledByteBuf.init(this, l2, this.runOffset(n4) + (n2 & 0x3FFFFFFF) * poolSubpage.elemSize, n3, poolSubpage.elemSize, this.arena.parent.threadCache());
    }

    private byte value(int n2) {
        return this.memoryMap[n2];
    }

    private void setValue(int n2, byte by) {
        this.memoryMap[n2] = by;
    }

    private byte depth(int n2) {
        return this.depthMap[n2];
    }

    private static int log2(int n2) {
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    private int runLength(int n2) {
        return 1 << this.log2ChunkSize - this.depth(n2);
    }

    private int runOffset(int n2) {
        int n3 = n2 ^ 1 << this.depth(n2);
        return n3 * this.runLength(n2);
    }

    private int subpageIdx(int n2) {
        return n2 ^ this.maxSubpageAllocs;
    }

    private static int memoryMapIdx(long l2) {
        return (int)l2;
    }

    private static int bitmapIdx(long l2) {
        return (int)(l2 >>> 32);
    }

    @Override
    public final int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public final int freeBytes() {
        return this.freeBytes;
    }

    public final String toString() {
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage() + "%, " + (this.chunkSize - this.freeBytes) + '/' + this.chunkSize + ')';
    }

    final void destroy() {
        this.arena.destroyChunk(this);
    }
}

