/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.PoolChunk;
import com.aliyun.openservices.shade.io.netty.buffer.PoolThreadCache;
import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler$Handle recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    private ByteBuffer tmpNioBuf;

    protected PooledByteBuf(Recycler$Handle recycler$Handle, int n2) {
        super(n2);
        this.recyclerHandle = recycler$Handle;
    }

    void init(PoolChunk<T> poolChunk, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        assert (l2 >= 0L);
        assert (poolChunk != null);
        this.chunk = poolChunk;
        this.handle = l2;
        this.memory = poolChunk.memory;
        this.offset = n2;
        this.length = n3;
        this.maxLength = n4;
        this.tmpNioBuf = null;
        this.cache = poolThreadCache;
    }

    void initUnpooled(PoolChunk<T> poolChunk, int n2) {
        assert (poolChunk != null);
        this.chunk = poolChunk;
        this.handle = 0L;
        this.memory = poolChunk.memory;
        this.offset = 0;
        PooledByteBuf pooledByteBuf = this;
        pooledByteBuf.length = pooledByteBuf.maxLength = n2;
        this.tmpNioBuf = null;
        this.cache = null;
    }

    final void reuse(int n2) {
        this.maxCapacity(n2);
        this.setRefCnt(1);
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final ByteBuf capacity(int n2) {
        this.ensureAccessible();
        if (this.chunk.unpooled) {
            if (n2 == this.length) {
                return this;
            }
        } else if (n2 > this.length) {
            if (n2 <= this.maxLength) {
                this.length = n2;
                return this;
            }
        } else {
            if (n2 >= this.length) return this;
            if (n2 > this.maxLength >>> 1) {
                if (this.maxLength <= 512) {
                    if (n2 > this.maxLength - 16) {
                        this.length = n2;
                        PooledByteBuf pooledByteBuf = this;
                        ((ByteBuf)pooledByteBuf).setIndex(Math.min(((ByteBuf)pooledByteBuf).readerIndex(), n2), Math.min(((ByteBuf)this).writerIndex(), n2));
                        return this;
                    }
                } else {
                    this.length = n2;
                    PooledByteBuf pooledByteBuf = this;
                    ((ByteBuf)pooledByteBuf).setIndex(Math.min(((ByteBuf)pooledByteBuf).readerIndex(), n2), Math.min(((ByteBuf)this).writerIndex(), n2));
                    return this;
                }
            }
        }
        this.chunk.arena.reallocate(this, n2, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.chunk.arena.parent;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.newInternalNioBuffer(this.memory);
        }
        return byteBuffer;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long l2 = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, l2, this.maxLength, this.cache);
            this.recycle();
        }
    }

    private void recycle() {
        Recycler$Handle recycler$Handle = this.recyclerHandle;
        if (recycler$Handle != null) {
            this.recycler().recycle(this, recycler$Handle);
        }
    }

    protected abstract Recycler<?> recycler();

    protected final int idx(int n2) {
        return this.offset + n2;
    }
}

