/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.PoolArena;
import com.aliyun.openservices.shade.io.netty.buffer.PoolArena$DirectArena;
import com.aliyun.openservices.shade.io.netty.buffer.PoolArena$HeapArena;
import com.aliyun.openservices.shade.io.netty.buffer.PoolArenaMetric;
import com.aliyun.openservices.shade.io.netty.buffer.PoolThreadCache;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator$PoolThreadLocalCache;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledHeapByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeByteBufUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_TINY_CACHE_SIZE;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    private static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int tinyCacheSize;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PooledByteBufAllocator$PoolThreadLocalCache threadCache = new PooledByteBufAllocator$PoolThreadLocalCache(this);

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n2, int n3, int n4, int n5) {
        this(false, n2, n3, n4, n5);
    }

    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5) {
        this(bl, n2, n3, n4, n5, DEFAULT_TINY_CACHE_SIZE, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(bl);
        void var3_6;
        void arrayList;
        void var5_8;
        void var4_7;
        void poolArena$HeapArena;
        int n9;
        int n10;
        this.tinyCacheSize = n10;
        this.smallCacheSize = n9;
        this.normalCacheSize = poolArena$HeapArena;
        int n11 = PooledByteBufAllocator.validateAndCalculateChunkSize((int)var4_7, (int)var5_8);
        if (arrayList < 0) {
            throw new IllegalArgumentException("nHeapArena: " + (int)arrayList + " (expected: >= 0)");
        }
        if (var3_6 < 0) {
            throw new IllegalArgumentException("nDirectArea: " + (int)var3_6 + " (expected: >= 0)");
        }
        n10 = PooledByteBufAllocator.validateAndCalculatePageShifts((int)var4_7);
        if (arrayList > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray((int)arrayList);
            ArrayList<PoolArena$HeapArena> arrayList2 = new ArrayList<PoolArena$HeapArena>(this.heapArenas.length);
            for (n9 = 0; n9 < this.heapArenas.length; ++n9) {
                PoolArena$HeapArena poolArena$DirectArena;
                this.heapArenas[n9] = poolArena$DirectArena = new PoolArena$HeapArena(this, (int)var4_7, (int)var5_8, n10, n11);
                arrayList2.add(poolArena$DirectArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList2);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (var3_6 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray((int)var3_6);
            ArrayList<PoolArena$DirectArena> arrayList3 = new ArrayList<PoolArena$DirectArena>(this.directArenas.length);
            for (n9 = 0; n9 < this.directArenas.length; ++n9) {
                PoolArena$DirectArena poolArena$DirectArena;
                this.directArenas[n9] = poolArena$DirectArena = new PoolArena$DirectArena(this, (int)var4_7, (int)var5_8, n10, n11);
                arrayList3.add(poolArena$DirectArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList3);
            return;
        }
        this.directArenas = null;
        this.directArenaMetrics = Collections.emptyList();
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        this(bl, n2, n3, n4, n5, n6, n7, n8);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n2) {
        return new PoolArena[n2];
    }

    private static int validateAndCalculatePageShifts(int n2) {
        if (n2 < 4096) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: 4096" + ")");
        }
        int n3 = n2;
        if ((n3 & n3 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    private static int validateAndCalculateChunkSize(int n2, int n3) {
        if (n3 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n3 + " (expected: 0-14)");
        }
        int n4 = n2;
        for (int i2 = n3; i2 > 0; --i2) {
            if (n4 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n2, n3, 0x40000000));
            }
            n4 <<= 1;
        }
        return n4;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n2, n3) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n2, n3);
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n2, n3) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n2, n3) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n2, n3));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static int defaultTinyCacheSize() {
        return DEFAULT_TINY_CACHE_SIZE;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    public int numThreadLocalCaches() {
        PoolArena<Object>[] poolArenaArray = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (poolArenaArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < poolArenaArray.length; ++i2) {
            n2 += poolArenaArray[i2].numThreadCaches.get();
        }
        return n2;
    }

    public int tinyCacheSize() {
        return this.tinyCacheSize;
    }

    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    final PoolThreadCache threadCache() {
        return (PoolThreadCache)this.threadCache.get();
    }

    public String dumpStats() {
        int n2;
        int n3 = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n3).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n3 > 0) {
            PoolArena<byte[]>[] poolArenaArray = this.heapArenas;
            int n4 = this.heapArenas.length;
            for (n2 = 0; n2 < n4; ++n2) {
                PoolArena<byte[]> poolArena = poolArenaArray[n2];
                stringBuilder.append(poolArena);
            }
        }
        n3 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n3).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n3 > 0) {
            PoolArena<ByteBuffer>[] poolArenaArray = this.directArenas;
            n2 = this.directArenas.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                PoolArena<ByteBuffer> poolArena = poolArenaArray[i2];
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ PoolArena[] access$000(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.heapArenas;
    }

    static /* synthetic */ PoolArena[] access$100(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.directArenas;
    }

    static /* synthetic */ int access$200(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.tinyCacheSize;
    }

    static /* synthetic */ int access$300(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.smallCacheSize;
    }

    static /* synthetic */ int access$400(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.normalCacheSize;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    }

    static /* synthetic */ int access$600() {
        return DEFAULT_CACHE_TRIM_INTERVAL;
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n2);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            n2 = 8192;
        }
        DEFAULT_PAGE_SIZE = n2;
        n2 = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.maxOrder", 11);
        Throwable throwable4 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n2);
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throwable4 = throwable5;
            n2 = 11;
        }
        DEFAULT_MAX_ORDER = n2;
        Runtime runtime = Runtime.getRuntime();
        int n3 = runtime.availableProcessors() << 1;
        int n4 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.numHeapArenas", (int)Math.min((long)n3, runtime.maxMemory() / (long)n4 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.numDirectArenas", (int)Math.min((long)n3, PlatformDependent.maxDirectMemory() / (long)n4 / 2L / 3L)));
        DEFAULT_TINY_CACHE_SIZE = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.tinyCacheSize", 512);
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.allocator.cacheTrimInterval", 8192);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable4 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable4);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.tinyCacheSize: {}", (Object)DEFAULT_TINY_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
        }
        DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }
}

