/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledDirectByteBuf$1;
import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new PooledDirectByteBuf$1();

    static PooledDirectByteBuf newInstance(int n2) {
        PooledDirectByteBuf pooledDirectByteBuf = RECYCLER.get();
        pooledDirectByteBuf.reuse(n2);
        return pooledDirectByteBuf;
    }

    private PooledDirectByteBuf(Recycler$Handle recycler$Handle, int n2) {
        super(recycler$Handle, n2);
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    protected final byte _getByte(int n2) {
        return ((ByteBuffer)this.memory).get(this.idx(n2));
    }

    @Override
    protected final short _getShort(int n2) {
        return ((ByteBuffer)this.memory).getShort(this.idx(n2));
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        n2 = this.idx(n2);
        return (((ByteBuffer)this.memory).get(n2) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(n2 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(n2 + 2) & 0xFF;
    }

    @Override
    protected final int _getInt(int n2) {
        return ((ByteBuffer)this.memory).getInt(this.idx(n2));
    }

    @Override
    protected final long _getLong(int n2) {
        return ((ByteBuffer)this.memory).getLong(this.idx(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBufferArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            ((ByteBuf)this).getBytes(n2, byteBufferArray.array(), byteBufferArray.arrayOffset() + n3, n4);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                ((ByteBuf)this).getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBufferArray.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.getBytes(n2, byArray, n3, n4, false);
        return this;
    }

    private void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, byArray, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.getBytes(n2, byteBuffer, false);
        return this;
    }

    private void getBytes(int n2, ByteBuffer byteBuffer, boolean bl) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, byteBuffer, true);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.getBytes(n2, outputStream, n3, false);
        return this;
    }

    private void getBytes(int n2, OutputStream outputStream, int n3, boolean bl) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return;
        }
        byte[] byArray = new byte[n3];
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        byteBuffer.clear().position(this.idx(n2));
        byteBuffer.get(byArray);
        outputStream.write(byArray);
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n2) {
        this.checkReadableBytes(n2);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, outputStream, n2, true);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        int n3 = pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        ((ByteBuffer)this.memory).put(this.idx(n2), (byte)n3);
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        ((ByteBuffer)this.memory).putShort(this.idx(n2), (short)n3);
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        n2 = this.idx(n2);
        ((ByteBuffer)this.memory).put(n2, (byte)(n3 >>> 16));
        ((ByteBuffer)this.memory).put(n2 + 1, (byte)(n3 >>> 8));
        ((ByteBuffer)this.memory).put(n2 + 2, (byte)n3);
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        ((ByteBuffer)this.memory).putInt(this.idx(n2), n3);
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        ((ByteBuffer)this.memory).putLong(this.idx(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBufferArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            ((ByteBuf)this).setBytes(n2, byteBufferArray.array(), byteBufferArray.arrayOffset() + n3, n4);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                ((ByteBuf)this).setBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBufferArray.getBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.put(byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        n2 = this.idx(n2);
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        byte[] byArray = new byte[n3];
        int n4 = inputStream.read(byArray);
        if (n4 <= 0) {
            return n4;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(this.idx(n2));
        byteBuffer.put(byArray, 0, n4);
        return n4;
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().directBuffer(n3, ((ByteBuf)this).maxCapacity());
        byteBuf.writeBytes(this, n2, n3);
        return byteBuf;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n2, n3)};
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Recycler<?> recycler() {
        return RECYCLER;
    }

    /* synthetic */ PooledDirectByteBuf(Recycler$Handle recycler$Handle, int n2, PooledDirectByteBuf$1 pooledDirectByteBuf$1) {
        this(recycler$Handle, n2);
    }
}

