/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.HeapByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledHeapByteBuf$1;
import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final Recycler<PooledHeapByteBuf> RECYCLER = new PooledHeapByteBuf$1();

    static PooledHeapByteBuf newInstance(int n2) {
        PooledHeapByteBuf pooledHeapByteBuf = RECYCLER.get();
        pooledHeapByteBuf.reuse(n2);
        return pooledHeapByteBuf;
    }

    PooledHeapByteBuf(Recycler$Handle recycler$Handle, int n2) {
        super(recycler$Handle, n2);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int n2) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(n2), byteBuf.memoryAddress() + (long)n3, (long)n4);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.setBytes(n3, (byte[])this.memory, this.idx(n2), n4);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        System.arraycopy(this.memory, this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2, byteBuffer.remaining());
        byteBuffer.put((byte[])this.memory, this.idx(n2), byteBuffer.remaining());
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.checkIndex(n2, n3);
        outputStream.write((byte[])this.memory, this.idx(n2), n3);
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ByteBuffer.wrap((byte[])this.memory);
        return gatheringByteChannel.write((ByteBuffer)byteBuffer.clear().position(n2).limit(n2 + n3));
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        PooledHeapByteBuf pooledHeapByteBuf = this;
        int n3 = pooledHeapByteBuf.getBytes(pooledHeapByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, (byte[])this.memory, this.idx(n2), (long)n4);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.getBytes(n3, (byte[])this.memory, this.idx(n2), n4);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        System.arraycopy(byArray, n3, this.memory, this.idx(n2), n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.remaining();
        this.checkIndex(n2, n3);
        byteBuffer.get((byte[])this.memory, this.idx(n2), n3);
        return this;
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        return inputStream.read((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        try {
            return scatteringByteChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().heapBuffer(n3, ((ByteBuf)this).maxCapacity());
        byteBuf.writeBytes((byte[])this.memory, this.idx(n2), n3);
        return byteBuf;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n2, n3)};
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])this.memory, n2, n3);
        return byteBuffer.slice();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }

    @Override
    protected Recycler<?> recycler() {
        return RECYCLER;
    }
}

