/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PoolChunk;
import com.aliyun.openservices.shade.io.netty.buffer.PoolThreadCache;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledUnsafeDirectByteBuf$1;
import com.aliyun.openservices.shade.io.netty.buffer.SwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledUnsafeDirectByteBuf> RECYCLER = new PooledUnsafeDirectByteBuf$1();
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = RECYCLER.get();
        pooledUnsafeDirectByteBuf.reuse(n2);
        return pooledUnsafeDirectByteBuf;
    }

    private PooledUnsafeDirectByteBuf(Recycler$Handle recycler$Handle, int n2) {
        super(recycler$Handle, n2);
    }

    @Override
    final void init(PoolChunk<ByteBuffer> poolChunk, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        super.init(poolChunk, l2, n2, n3, n4, poolThreadCache);
        this.initMemoryAddress();
    }

    @Override
    final void initUnpooled(PoolChunk<ByteBuffer> poolChunk, int n2) {
        super.initUnpooled(poolChunk, n2);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    protected final byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected final short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected final int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected final long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        ((ByteBuf)pooledUnsafeDirectByteBuf).getBytes(pooledUnsafeDirectByteBuf.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, outputStream, n3);
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        int n3 = pooledUnsafeDirectByteBuf.getBytes(pooledUnsafeDirectByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), (byte)n3);
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, inputStream, n3);
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, n3);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n2, n3)};
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected final Recycler<?> recycler() {
        return RECYCLER;
    }

    @Override
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public final ByteBuf setZero(int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setZero(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, n3);
        return this;
    }

    @Override
    public final ByteBuf writeZero(int n2) {
        ((ByteBuf)this).ensureWritable(n2);
        int n3 = this.writerIndex;
        ((ByteBuf)this).setZero(n3, n2);
        this.writerIndex = n3 + n2;
        return this;
    }

    /* synthetic */ PooledUnsafeDirectByteBuf(Recycler$Handle recycler$Handle, int n2, PooledUnsafeDirectByteBuf$1 pooledUnsafeDirectByteBuf$1) {
        this(recycler$Handle, n2);
    }
}

