/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.SimpleLeakAwareByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.WrappedCompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import java.nio.ByteOrder;

final class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    private final ResourceLeak leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf compositeByteBuf, ResourceLeak resourceLeak) {
        super(compositeByteBuf);
        this.leak = resourceLeak;
    }

    @Override
    public final boolean release() {
        boolean bl = super.release();
        if (bl) {
            this.leak.close();
        }
        return bl;
    }

    @Override
    public final boolean release(int n2) {
        boolean bl = super.release(n2);
        n2 = bl ? 1 : 0;
        if (bl) {
            this.leak.close();
        }
        return n2 != 0;
    }

    @Override
    public final ByteBuf order(ByteOrder byteOrder) {
        this.leak.record();
        if (((ByteBuf)this).order() == byteOrder) {
            return this;
        }
        return new SimpleLeakAwareByteBuf(super.order(byteOrder), this.leak);
    }

    @Override
    public final ByteBuf slice() {
        return new SimpleLeakAwareByteBuf(super.slice(), this.leak);
    }

    @Override
    public final ByteBuf slice(int n2, int n3) {
        return new SimpleLeakAwareByteBuf(super.slice(n2, n3), this.leak);
    }

    @Override
    public final ByteBuf duplicate() {
        return new SimpleLeakAwareByteBuf(super.duplicate(), this.leak);
    }

    @Override
    public final ByteBuf readSlice(int n2) {
        return new SimpleLeakAwareByteBuf(super.readSlice(n2), this.leak);
    }
}

