/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.EmptyByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.FixedCompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ReadOnlyByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ReadOnlyByteBufferBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledHeapByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnreleasableByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class Unpooled {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ByteBuf EMPTY_BUFFER = ALLOC.buffer(0, 0);

    public static ByteBuf buffer() {
        return ALLOC.heapBuffer();
    }

    public static ByteBuf directBuffer() {
        return ALLOC.directBuffer();
    }

    public static ByteBuf buffer(int n2) {
        return ALLOC.heapBuffer(n2);
    }

    public static ByteBuf directBuffer(int n2) {
        return ALLOC.directBuffer(n2);
    }

    public static ByteBuf buffer(int n2, int n3) {
        return ALLOC.heapBuffer(n2, n3);
    }

    public static ByteBuf directBuffer(int n2, int n3) {
        return ALLOC.directBuffer(n2, n3);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return new UnpooledHeapByteBuf(ALLOC, byArray, byArray.length);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        if (n2 == 0 && n3 == byArray.length) {
            return Unpooled.wrappedBuffer(byArray);
        }
        return Unpooled.wrappedBuffer(byArray).slice(n2, n3);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!byteBuffer.isDirect() && byteBuffer.hasArray()) {
            return Unpooled.wrappedBuffer(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()).order(byteBuffer.order());
        }
        if (PlatformDependent.hasUnsafe()) {
            if (byteBuffer.isReadOnly()) {
                if (byteBuffer.isDirect()) {
                    return new ReadOnlyUnsafeDirectByteBuf(ALLOC, byteBuffer);
                }
                return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return new UnpooledUnsafeDirectByteBuf(ALLOC, byteBuffer2, byteBuffer2.remaining());
        }
        if (byteBuffer.isReadOnly()) {
            return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        return new UnpooledDirectByteBuf(ALLOC, byteBuffer3, byteBuffer3.remaining());
    }

    public static ByteBuf wrappedBuffer(long l2, int n2, boolean bl) {
        return new WrappedUnpooledUnsafeDirectByteBuf(ALLOC, l2, n2, bl);
    }

    public static ByteBuf wrappedBuffer(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return byteBuf.slice();
        }
        byteBuf.release();
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(byte[] ... byArray) {
        return Unpooled.wrappedBuffer(16, byArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedBuffer(16, byteBufArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer ... byteBufferArray) {
        return Unpooled.wrappedBuffer(16, byteBufferArray);
    }

    public static ByteBuf wrappedBuffer(int n2, byte[] ... byArray) {
        switch (byArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (byArray[0].length == 0) break;
                return Unpooled.wrappedBuffer(byArray[0]);
            }
            default: {
                ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(byArray.length);
                for (byte[] byArray2 : byArray) {
                    if (byArray2 == null) break;
                    if (byArray2.length <= 0) continue;
                    arrayList.add(Unpooled.wrappedBuffer(byArray2));
                }
                if (arrayList.isEmpty()) break;
                return new CompositeByteBuf(ALLOC, false, n2, arrayList);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n2, ByteBuf ... byteBufArray) {
        switch (byteBufArray.length) {
            case 0: {
                break;
            }
            case 1: {
                ByteBuf byteBuf = byteBufArray[0];
                if (byteBuf.isReadable()) {
                    return Unpooled.wrappedBuffer(byteBuf.order(BIG_ENDIAN));
                }
                byteBuf.release();
                break;
            }
            default: {
                for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                    ByteBuf byteBuf = byteBufArray[i2];
                    if (byteBuf.isReadable()) {
                        return new CompositeByteBuf(ALLOC, false, n2, byteBufArray, i2, byteBufArray.length);
                    }
                    byteBuf.release();
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n2, ByteBuffer ... byteBufferArray) {
        switch (byteBufferArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!byteBufferArray[0].hasRemaining()) break;
                return Unpooled.wrappedBuffer(byteBufferArray[0].order(BIG_ENDIAN));
            }
            default: {
                ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(byteBufferArray.length);
                for (ByteBuffer byteBuffer : byteBufferArray) {
                    if (byteBuffer == null) break;
                    if (byteBuffer.remaining() <= 0) continue;
                    arrayList.add(Unpooled.wrappedBuffer(byteBuffer.order(BIG_ENDIAN)));
                }
                if (arrayList.isEmpty()) break;
                return new CompositeByteBuf(ALLOC, false, n2, arrayList);
            }
        }
        return EMPTY_BUFFER;
    }

    public static CompositeByteBuf compositeBuffer() {
        return Unpooled.compositeBuffer(16);
    }

    public static CompositeByteBuf compositeBuffer(int n2) {
        return new CompositeByteBuf(ALLOC, false, n2);
    }

    public static ByteBuf copiedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((byte[])byArray.clone());
    }

    public static ByteBuf copiedBuffer(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return Unpooled.wrappedBuffer(byArray2);
    }

    public static ByteBuf copiedBuffer(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = new byte[n2];
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.get(byArray);
        return Unpooled.wrappedBuffer(byArray).order(byteBuffer.order());
    }

    public static ByteBuf copiedBuffer(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 > 0) {
            ByteBuf byteBuf2 = Unpooled.buffer(n2);
            ByteBuf byteBuf3 = byteBuf;
            byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
            return byteBuf2;
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf copiedBuffer(byte[] ... byArray) {
        byte[] byArray2;
        int n2;
        switch (byArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (byArray[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return Unpooled.copiedBuffer(byArray[0]);
            }
        }
        int n3 = 0;
        Object object = byArray;
        int n4 = byArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            byArray2 = object[n2];
            if (Integer.MAX_VALUE - n3 < byArray2.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            n3 += byArray2.length;
        }
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        object = new byte[n3];
        n2 = 0;
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray2 = byArray[n4];
            System.arraycopy(byArray2, 0, object, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return Unpooled.wrappedBuffer((byte[])object);
    }

    public static ByteBuf copiedBuffer(ByteBuf ... byteBufArray) {
        int n2;
        ByteBuf byteBuf;
        int n3;
        switch (byteBufArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n4 = 0;
        Object[] objectArray = byteBufArray;
        int n5 = byteBufArray.length;
        for (n3 = 0; n3 < n5; ++n3) {
            byteBuf = objectArray[n3];
            n2 = byteBuf.readableBytes();
            if (n2 <= 0) continue;
            if (Integer.MAX_VALUE - n4 < n2) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n4 += n2;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuf.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuf.order();
        }
        if (n4 == 0) {
            return EMPTY_BUFFER;
        }
        objectArray = new byte[n4];
        n3 = 0;
        for (n5 = 0; n5 < byteBufArray.length; ++n5) {
            byteBuf = byteBufArray[n5];
            n2 = byteBuf.readableBytes();
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), (byte[])objectArray, n3, n2);
            n3 += n2;
        }
        return Unpooled.wrappedBuffer((byte[])objectArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(ByteBuffer ... byteBufferArray) {
        int n2;
        ByteBuffer byteBuffer;
        int n3;
        switch (byteBufferArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufferArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n4 = 0;
        Object[] objectArray = byteBufferArray;
        int n5 = byteBufferArray.length;
        for (n3 = 0; n3 < n5; ++n3) {
            byteBuffer = objectArray[n3];
            n2 = byteBuffer.remaining();
            if (n2 <= 0) continue;
            if (Integer.MAX_VALUE - n4 < n2) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n4 += n2;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuffer.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuffer.order();
        }
        if (n4 == 0) {
            return EMPTY_BUFFER;
        }
        objectArray = new byte[n4];
        n3 = 0;
        for (n5 = 0; n5 < byteBufferArray.length; ++n5) {
            byteBuffer = byteBufferArray[n5].duplicate();
            n2 = byteBuffer.remaining();
            byteBuffer.get((byte[])objectArray, n3, n2);
            n3 += n2;
        }
        return Unpooled.wrappedBuffer((byte[])objectArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (charSequence instanceof CharBuffer) {
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence), charset);
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, int n2, int n3, Charset charset) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        if (charSequence instanceof CharBuffer) {
            if (((CharBuffer)(charSequence = (CharBuffer)charSequence)).hasArray()) {
                return Unpooled.copiedBuffer(((CharBuffer)charSequence).array(), ((CharBuffer)charSequence).arrayOffset() + ((Buffer)((Object)charSequence)).position() + n2, n3, charset);
            }
            charSequence = ((CharBuffer)charSequence).slice();
            ((CharBuffer)charSequence).limit(n3);
            ((CharBuffer)charSequence).position(n2);
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        int n4 = n2;
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence, n4, n4 + n3), charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, Charset charset) {
        if (cArray == null) {
            throw new NullPointerException("array");
        }
        return Unpooled.copiedBuffer(cArray, 0, cArray.length, charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, int n2, int n3, Charset charset) {
        if (cArray == null) {
            throw new NullPointerException("array");
        }
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(cArray, n2, n3), charset);
    }

    private static ByteBuf copiedBuffer(CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(ALLOC, true, charBuffer, charset);
    }

    public static ByteBuf unmodifiableBuffer(ByteBuf byteBuf) {
        ByteOrder byteOrder = byteBuf.order();
        if (byteOrder == BIG_ENDIAN) {
            return new ReadOnlyByteBuf(byteBuf);
        }
        return ((ByteBuf)new ReadOnlyByteBuf(byteBuf.order(BIG_ENDIAN))).order(LITTLE_ENDIAN);
    }

    public static ByteBuf copyInt(int n2) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeInt(n2);
        return byteBuf;
    }

    public static ByteBuf copyInt(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length << 2);
        for (int n2 : nArray) {
            byteBuf.writeInt(n2);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int n2) {
        ByteBuf byteBuf = Unpooled.buffer(2);
        byteBuf.writeShort(n2);
        return byteBuf;
    }

    public static ByteBuf copyShort(short ... sArray) {
        if (sArray == null || sArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(sArray.length << 1);
        for (short s2 : sArray) {
            byteBuf.writeShort(s2);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length << 1);
        for (int n2 : nArray) {
            byteBuf.writeShort(n2);
        }
        return byteBuf;
    }

    public static ByteBuf copyMedium(int n2) {
        ByteBuf byteBuf = Unpooled.buffer(3);
        byteBuf.writeMedium(n2);
        return byteBuf;
    }

    public static ByteBuf copyMedium(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length * 3);
        for (int n2 : nArray) {
            byteBuf.writeMedium(n2);
        }
        return byteBuf;
    }

    public static ByteBuf copyLong(long l2) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeLong(l2);
        return byteBuf;
    }

    public static ByteBuf copyLong(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(lArray.length << 3);
        for (long l2 : lArray) {
            byteBuf.writeLong(l2);
        }
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean bl) {
        ByteBuf byteBuf = Unpooled.buffer(1);
        byteBuf.writeBoolean(bl);
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean ... blArray) {
        if (blArray == null || blArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(blArray.length);
        for (boolean bl : blArray) {
            byteBuf.writeBoolean(bl);
        }
        return byteBuf;
    }

    public static ByteBuf copyFloat(float f2) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeFloat(f2);
        return byteBuf;
    }

    public static ByteBuf copyFloat(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(fArray.length << 2);
        for (float f2 : fArray) {
            byteBuf.writeFloat(f2);
        }
        return byteBuf;
    }

    public static ByteBuf copyDouble(double d2) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeDouble(d2);
        return byteBuf;
    }

    public static ByteBuf copyDouble(double ... dArray) {
        if (dArray == null || dArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(dArray.length << 3);
        for (double d2 : dArray) {
            byteBuf.writeDouble(d2);
        }
        return byteBuf;
    }

    public static ByteBuf unreleasableBuffer(ByteBuf byteBuf) {
        return new UnreleasableByteBuf(byteBuf);
    }

    public static ByteBuf unmodifiableBuffer(ByteBuf ... byteBufArray) {
        return new FixedCompositeByteBuf(ALLOC, byteBufArray);
    }

    private Unpooled() {
    }

    static {
        assert (EMPTY_BUFFER instanceof EmptyByteBuf) : "EMPTY_BUFFER must be an EmptyByteBuf.";
    }
}

