/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledHeapByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeByteBufUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator {
    private final boolean disableLeakDetector;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl) {
        this(bl, false);
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2) {
        super(bl);
        this.disableLeakDetector = bl2;
    }

    @Override
    protected final ByteBuf newHeapBuffer(int n2, int n3) {
        if (PlatformDependent.hasUnsafe()) {
            return new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n2, n3);
        }
        return new UnpooledHeapByteBuf((ByteBufAllocator)this, n2, n3);
    }

    @Override
    protected final ByteBuf newDirectBuffer(int n2, int n3) {
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf2 = abstractReferenceCountedByteBuf = PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n2, n3) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n2, n3);
        if (this.disableLeakDetector) {
            return abstractReferenceCountedByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    public final CompositeByteBuf compositeHeapBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n2);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public final CompositeByteBuf compositeDirectBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n2);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public final boolean isDirectBufferPooled() {
        return false;
    }
}

