/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.HeapByteBufUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    protected UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        this(byteBufAllocator, new byte[n2], 0, 0, n3);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, byte[] byArray, int n2) {
        this(byteBufAllocator, byArray, 0, byArray.length, n2);
    }

    private UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, byte[] byArray, int n2, int n3, int n4) {
        super(n4);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (byArray == null) {
            throw new NullPointerException("initialArray");
        }
        if (byArray.length > n4) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", byArray.length, n4));
        }
        this.alloc = byteBufAllocator;
        this.setArray(byArray);
        ((ByteBuf)this).setIndex(n2, n3);
    }

    private void setArray(byte[] byArray) {
        this.array = byArray;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        this.ensureAccessible();
        return this.array.length;
    }

    @Override
    public ByteBuf capacity(int n2) {
        block9: {
            byte[] byArray;
            block8: {
                int n3;
                block7: {
                    this.ensureAccessible();
                    if (n2 < 0 || n2 > ((ByteBuf)this).maxCapacity()) {
                        throw new IllegalArgumentException("newCapacity: " + n2);
                    }
                    n3 = this.array.length;
                    if (n2 <= n3) break block7;
                    byArray = new byte[n2];
                    System.arraycopy(this.array, 0, byArray, 0, this.array.length);
                    break block8;
                }
                if (n2 >= n3) break block9;
                byArray = new byte[n2];
                int n4 = ((ByteBuf)this).readerIndex();
                if (n4 < n2) {
                    int n5 = ((ByteBuf)this).writerIndex();
                    if (n5 > n2) {
                        n5 = n2;
                        ((ByteBuf)this).writerIndex(n5);
                    }
                    System.arraycopy(this.array, n4, byArray, n4, n5 - n4);
                } else {
                    int n6 = n2;
                    ((ByteBuf)this).setIndex(n6, n6);
                }
            }
            this.setArray(byArray);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, n2, byteBuf.memoryAddress() + (long)n3, (long)n4);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.setBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        System.arraycopy(this.array, n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2, byteBuffer.remaining());
        byteBuffer.put(this.array, n2, byteBuffer.remaining());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.ensureAccessible();
        outputStream.write(this.array, n2, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.ensureAccessible();
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return gatheringByteChannel.write((ByteBuffer)byteBuffer.clear().position(n2).limit(n2 + n3));
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        int n3 = unpooledHeapByteBuf.getBytes(unpooledHeapByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, this.array, n2, (long)n4);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.getBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        System.arraycopy(byArray, n3, this.array, n2, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.get(this.array, n2, byteBuffer.remaining());
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.ensureAccessible();
        return inputStream.read(this.array, n2, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.ensureAccessible();
        try {
            return scatteringByteChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, n2, n3).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return HeapByteBufUtil.getByte(this.array, n2);
    }

    @Override
    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return HeapByteBufUtil.getShort(this.array, n2);
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, n2);
    }

    @Override
    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return HeapByteBufUtil.getInt(this.array, n2);
    }

    @Override
    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return HeapByteBufUtil.getLong(this.array, n2);
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.ensureAccessible();
        this._setByte(n2, n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        HeapByteBufUtil.setByte(this.array, n2, n3);
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.ensureAccessible();
        this._setShort(n2, n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        HeapByteBufUtil.setShort(this.array, n2, n3);
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.ensureAccessible();
        this._setMedium(n2, n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        HeapByteBufUtil.setMedium(this.array, n2, n3);
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.ensureAccessible();
        this._setInt(n2, n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        HeapByteBufUtil.setInt(this.array, n2, n3);
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.ensureAccessible();
        this._setLong(n2, l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        HeapByteBufUtil.setLong(this.array, n2, l2);
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.array, n2, byArray, 0, n3);
        return new UnpooledHeapByteBuf(((ByteBuf)this).alloc(), byArray, ((ByteBuf)this).maxCapacity());
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = ByteBuffer.wrap(this.array);
        }
        return byteBuffer;
    }

    @Override
    protected void deallocate() {
        this.array = null;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

