/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.SwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledUnsafeDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;
    ByteBuffer buffer;
    long memoryAddress;

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("maxCapacity: " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = byteBufAllocator;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        unpooledUnsafeDirectByteBuf.setByteBuffer(unpooledUnsafeDirectByteBuf.allocateDirect(n2), false);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2) {
        this(byteBufAllocator, byteBuffer, n2, true);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2, boolean bl) {
        super(n2);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (byteBuffer == null) {
            throw new NullPointerException("initialBuffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int n3 = byteBuffer.remaining();
        if (n3 > n2) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n3, n2));
        }
        this.alloc = byteBufAllocator;
        this.doNotFree = !bl;
        this.setByteBuffer(byteBuffer.slice().order(ByteOrder.BIG_ENDIAN), false);
        ((ByteBuf)this).writerIndex(n3);
    }

    protected ByteBuffer allocateDirect(int n2) {
        return ByteBuffer.allocateDirect(n2);
    }

    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer(byteBuffer);
    }

    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        ByteBuffer byteBuffer2;
        if (bl && (byteBuffer2 = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(byteBuffer2);
            }
        }
        this.buffer = byteBuffer;
        this.memoryAddress = PlatformDependent.directBufferAddress(byteBuffer);
        this.tmpNioBuf = null;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n2) {
        block9: {
            ByteBuffer byteBuffer;
            block8: {
                int n3;
                int n4;
                int n5;
                block7: {
                    this.ensureAccessible();
                    if (n2 < 0 || n2 > ((ByteBuf)this).maxCapacity()) {
                        throw new IllegalArgumentException("newCapacity: " + n2);
                    }
                    n5 = ((ByteBuf)this).readerIndex();
                    n4 = ((ByteBuf)this).writerIndex();
                    n3 = this.capacity;
                    if (n2 <= n3) break block7;
                    ByteBuffer byteBuffer2 = this.buffer;
                    byteBuffer = this.allocateDirect(n2);
                    byteBuffer2.position(0).limit(byteBuffer2.capacity());
                    byteBuffer.position(0).limit(byteBuffer2.capacity());
                    byteBuffer.put(byteBuffer2);
                    byteBuffer.clear();
                    break block8;
                }
                if (n2 >= n3) break block9;
                ByteBuffer byteBuffer3 = this.buffer;
                byteBuffer = this.allocateDirect(n2);
                if (n5 < n2) {
                    if (n4 > n2) {
                        n4 = n2;
                        ((ByteBuf)this).writerIndex(n4);
                    }
                    byteBuffer3.position(n5).limit(n4);
                    byteBuffer.position(n5).limit(n4);
                    byteBuffer.put(byteBuffer3);
                    byteBuffer.clear();
                } else {
                    int n6 = n2;
                    ((ByteBuf)this).setIndex(n6, n6);
                }
            }
            this.setByteBuffer(byteBuffer, true);
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        ((ByteBuf)unpooledUnsafeDirectByteBuf).getBytes(unpooledUnsafeDirectByteBuf.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, outputStream, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        int n3 = unpooledUnsafeDirectByteBuf.getBytes(unpooledUnsafeDirectByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, inputStream, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, n3);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    protected void deallocate() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(byteBuffer);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setZero(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, n3);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n2) {
        ((ByteBuf)this).ensureWritable(n2);
        int n3 = this.writerIndex;
        ((ByteBuf)this).setZero(n3, n2);
        this.writerIndex = n3 + n2;
        return this;
    }
}

