/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.util.internal.MathUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    static final boolean BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;

    static byte getByte(long l2) {
        return PlatformDependent.getByte(l2);
    }

    static short getShort(long l2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(l2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return s2;
            }
            return Short.reverseBytes(s2);
        }
        return (short)(PlatformDependent.getByte(l2) << 8 | PlatformDependent.getByte(l2 + 1L) & 0xFF);
    }

    static int getUnsignedMedium(long l2) {
        if (UNALIGNED) {
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return PlatformDependent.getByte(l2) & 0xFF | (PlatformDependent.getShort(l2 + 1L) & 0xFFFF) << 8;
            }
            return (Short.reverseBytes(PlatformDependent.getShort(l2)) & 0xFFFF) << 8 | PlatformDependent.getByte(l2 + 2L) & 0xFF;
        }
        return (PlatformDependent.getByte(l2) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 2L) & 0xFF;
    }

    static int getInt(long l2) {
        if (UNALIGNED) {
            int n2 = PlatformDependent.getInt(l2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return n2;
            }
            return Integer.reverseBytes(n2);
        }
        return PlatformDependent.getByte(l2) << 24 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 3L) & 0xFF;
    }

    static long getLong(long l2) {
        if (UNALIGNED) {
            long l3 = PlatformDependent.getLong(l2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return l3;
            }
            return Long.reverseBytes(l3);
        }
        return (long)PlatformDependent.getByte(l2) << 56 | ((long)PlatformDependent.getByte(l2 + 1L) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(l2 + 2L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(l2 + 3L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(l2 + 4L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(l2 + 5L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(l2 + 6L) & 0xFFL) << 8 | (long)PlatformDependent.getByte(l2 + 7L) & 0xFFL;
    }

    static void setByte(long l2, int n2) {
        PlatformDependent.putByte(l2, (byte)n2);
    }

    static void setShort(long l2, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(l2, BIG_ENDIAN_NATIVE_ORDER ? (short)n2 : Short.reverseBytes((short)n2));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 1L, (byte)n2);
    }

    static void setMedium(long l2, int n2) {
        if (UNALIGNED) {
            if (BIG_ENDIAN_NATIVE_ORDER) {
                PlatformDependent.putByte(l2, (byte)n2);
                PlatformDependent.putShort(l2 + 1L, (short)(n2 >>> 8));
                return;
            }
            PlatformDependent.putShort(l2, Short.reverseBytes((short)(n2 >>> 8)));
            PlatformDependent.putByte(l2 + 2L, (byte)n2);
            return;
        }
        PlatformDependent.putByte(l2, (byte)(n2 >>> 16));
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 2L, (byte)n2);
    }

    static void setInt(long l2, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(l2, BIG_ENDIAN_NATIVE_ORDER ? n2 : Integer.reverseBytes(n2));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(n2 >>> 24));
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 16));
        PlatformDependent.putByte(l2 + 2L, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 3L, (byte)n2);
    }

    static void setLong(long l2, long l3) {
        if (UNALIGNED) {
            PlatformDependent.putLong(l2, BIG_ENDIAN_NATIVE_ORDER ? l3 : Long.reverseBytes(l3));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(l3 >>> 56));
        PlatformDependent.putByte(l2 + 1L, (byte)(l3 >>> 48));
        PlatformDependent.putByte(l2 + 2L, (byte)(l3 >>> 40));
        PlatformDependent.putByte(l2 + 3L, (byte)(l3 >>> 32));
        PlatformDependent.putByte(l2 + 4L, (byte)(l3 >>> 24));
        PlatformDependent.putByte(l2 + 5L, (byte)(l3 >>> 16));
        PlatformDependent.putByte(l2 + 6L, (byte)(l3 >>> 8));
        PlatformDependent.putByte(l2 + 7L, (byte)l3);
    }

    static byte getByte(byte[] byArray, int n2) {
        return PlatformDependent.getByte(byArray, n2);
    }

    static short getShort(byte[] byArray, int n2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(byArray, n2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return s2;
            }
            return Short.reverseBytes(s2);
        }
        return (short)(PlatformDependent.getByte(byArray, n2) << 8 | PlatformDependent.getByte(byArray, n2 + 1) & 0xFF);
    }

    static int getUnsignedMedium(byte[] byArray, int n2) {
        if (UNALIGNED) {
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return PlatformDependent.getByte(byArray, n2) & 0xFF | (PlatformDependent.getShort(byArray, n2 + 1) & 0xFFFF) << 8;
            }
            return (Short.reverseBytes(PlatformDependent.getShort(byArray, n2)) & 0xFFFF) << 8 | PlatformDependent.getByte(byArray, n2 + 2) & 0xFF;
        }
        return (PlatformDependent.getByte(byArray, n2) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n2 + 1) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n2 + 2) & 0xFF;
    }

    static int getInt(byte[] byArray, int n2) {
        if (UNALIGNED) {
            int n3 = PlatformDependent.getInt(byArray, n2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return n3;
            }
            return Integer.reverseBytes(n3);
        }
        return PlatformDependent.getByte(byArray, n2) << 24 | (PlatformDependent.getByte(byArray, n2 + 1) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n2 + 2) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n2 + 3) & 0xFF;
    }

    static long getLong(byte[] byArray, int n2) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong(byArray, n2);
            if (BIG_ENDIAN_NATIVE_ORDER) {
                return l2;
            }
            return Long.reverseBytes(l2);
        }
        return (long)PlatformDependent.getByte(byArray, n2) << 56 | ((long)PlatformDependent.getByte(byArray, n2 + 1) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(byArray, n2 + 2) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(byArray, n2 + 3) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(byArray, n2 + 4) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(byArray, n2 + 5) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(byArray, n2 + 6) & 0xFFL) << 8 | (long)PlatformDependent.getByte(byArray, n2 + 7) & 0xFFL;
    }

    static void setByte(byte[] byArray, int n2, int n3) {
        PlatformDependent.putByte(byArray, n2, (byte)n3);
    }

    static void setShort(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n2, BIG_ENDIAN_NATIVE_ORDER ? (short)n3 : Short.reverseBytes((short)n3));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)n3);
    }

    static void setMedium(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            if (BIG_ENDIAN_NATIVE_ORDER) {
                PlatformDependent.putByte(byArray, n2, (byte)n3);
                PlatformDependent.putShort(byArray, n2 + 1, (short)(n3 >>> 8));
                return;
            }
            PlatformDependent.putShort(byArray, n2, Short.reverseBytes((short)(n3 >>> 8)));
            PlatformDependent.putByte(byArray, n2 + 2, (byte)n3);
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 16));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)n3);
    }

    static void setInt(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            PlatformDependent.putInt(byArray, n2, BIG_ENDIAN_NATIVE_ORDER ? n3 : Integer.reverseBytes(n3));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 24));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 16));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 3, (byte)n3);
    }

    static void setLong(byte[] byArray, int n2, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(byArray, n2, BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(l2 >>> 56));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(l2 >>> 48));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)(l2 >>> 40));
        PlatformDependent.putByte(byArray, n2 + 3, (byte)(l2 >>> 32));
        PlatformDependent.putByte(byArray, n2 + 4, (byte)(l2 >>> 24));
        PlatformDependent.putByte(byArray, n2 + 5, (byte)(l2 >>> 16));
        PlatformDependent.putByte(byArray, n2 + 6, (byte)(l2 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 7, (byte)l2);
    }

    static void setZero(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        PlatformDependent.setMemory(byArray, n2, n3, (byte)0);
    }

    static ByteBuf copy(AbstractByteBuf abstractByteBuf, long l2, int n2, int n3) {
        abstractByteBuf.checkIndex(n2, n3);
        ByteBuf byteBuf = abstractByteBuf.alloc().directBuffer(n3, ((ByteBuf)abstractByteBuf).maxCapacity());
        if (n3 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(l2, byteBuf.memoryAddress(), n3);
                byteBuf.setIndex(0, n3);
            } else {
                byteBuf.writeBytes(abstractByteBuf, n2, n3);
            }
        }
        return byteBuf;
    }

    static int setBytes(AbstractByteBuf byteBuf, long l2, int n2, InputStream inputStream, int n3) {
        ((AbstractByteBuf)byteBuf).checkIndex(n2, n3);
        byteBuf = byteBuf.alloc().heapBuffer(n3);
        try {
            byte[] byArray = byteBuf.array();
            int n4 = byteBuf.arrayOffset();
            int n5 = inputStream.read(byArray, n4, n3);
            if (n5 > 0) {
                PlatformDependent.copyMemory(byArray, n4, l2, (long)n5);
            }
            return n5;
        }
        finally {
            byteBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuf byteBuf, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byteBuf, "dst");
        if (MathUtil.isOutOfBounds(n3, n4, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + n3);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(l2, byteBuf.memoryAddress() + (long)n3, n4);
            return;
        }
        if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuf.array(), byteBuf.arrayOffset() + n3, (long)n4);
            return;
        }
        byteBuf.setBytes(n3, abstractByteBuf, n2, n4);
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, byte[] byArray, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byArray, "dst");
        if (MathUtil.isOutOfBounds(n3, n4, byArray.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + n3);
        }
        if (n4 != 0) {
            PlatformDependent.copyMemory(l2, byArray, n3, (long)n4);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuffer byteBuffer) {
        abstractByteBuf.checkIndex(n2, byteBuffer.remaining());
        if (byteBuffer.remaining() == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            if (byteBuffer.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long l3 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l2, l3 + (long)byteBuffer.position(), byteBuffer.remaining());
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + byteBuffer.remaining());
            return;
        }
        if (byteBuffer.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), (long)byteBuffer.remaining());
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.position() + byteBuffer.remaining());
            return;
        }
        byteBuffer.put(((ByteBuf)abstractByteBuf).nioBuffer());
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuf byteBuf, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byteBuf, "src");
        if (MathUtil.isOutOfBounds(n3, n4, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + n3);
        }
        if (n4 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, l2, n4);
                return;
            }
            if (byteBuf.hasArray()) {
                PlatformDependent.copyMemory(byteBuf.array(), byteBuf.arrayOffset() + n3, l2, (long)n4);
                return;
            }
            byteBuf.getBytes(n3, abstractByteBuf, n2, n4);
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, byte[] byArray, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        if (n4 != 0) {
            PlatformDependent.copyMemory(byArray, n3, l2, (long)n4);
        }
    }

    static void setBytes(AbstractByteBuf byteBuf, long l2, int n2, ByteBuffer byteBuffer) {
        ((AbstractByteBuf)byteBuf).checkIndex(n2, byteBuffer.remaining());
        n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            long l3 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l3 + (long)byteBuffer.position(), l2, byteBuffer.remaining());
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + n2);
            return;
        }
        if (byteBuffer.hasArray()) {
            PlatformDependent.copyMemory(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), l2, (long)n2);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.position() + n2);
            return;
        }
        byteBuf = byteBuf.alloc().heapBuffer(n2);
        try {
            byte[] byArray = byteBuf.array();
            byteBuffer.get(byArray, byteBuf.arrayOffset(), n2);
            PlatformDependent.copyMemory(byArray, byteBuf.arrayOffset(), l2, (long)n2);
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf byteBuf, long l2, int n2, OutputStream outputStream, int n3) {
        ((AbstractByteBuf)byteBuf).checkIndex(n2, n3);
        if (n3 != 0) {
            byteBuf = byteBuf.alloc().heapBuffer(n3);
            try {
                byte[] byArray = byteBuf.array();
                int n4 = byteBuf.arrayOffset();
                PlatformDependent.copyMemory(l2, byArray, n4, (long)n3);
                outputStream.write(byArray, n4, n3);
                return;
            }
            finally {
                byteBuf.release();
            }
        }
    }

    static void setZero(AbstractByteBuf abstractByteBuf, long l2, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        abstractByteBuf.checkIndex(n2, n3);
        PlatformDependent.setMemory(l2, n3, (byte)0);
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(byteBufAllocator, n2, n3);
        }
        return new UnpooledUnsafeDirectByteBuf(byteBufAllocator, n2, n3);
    }

    private UnsafeByteBufUtil() {
    }
}

