/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$1;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$2;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$3;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$4;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$5;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$6;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$7;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe$8;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AnnotatedConnectException;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AnnotatedNoRouteToHostException;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AnnotatedSocketException;
import com.aliyun.openservices.shade.io.netty.channel.Channel$Unsafe;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.VoidChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericFutureListener;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel$AbstractUnsafe
implements Channel$Unsafe {
    private volatile ChannelOutboundBuffer outboundBuffer;
    private boolean inFlush0;
    private boolean neverRegistered;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractChannel this$0;

    public AbstractChannel$AbstractUnsafe(AbstractChannel abstractChannel) {
        this.this$0 = abstractChannel;
        this.outboundBuffer = new ChannelOutboundBuffer(this.this$0);
        this.neverRegistered = true;
    }

    private void assertEventLoop() {
        if (!$assertionsDisabled && AbstractChannel.access$000(this.this$0) && !AbstractChannel.access$100(this.this$0).inEventLoop()) {
            throw new AssertionError();
        }
    }

    @Override
    public final ChannelOutboundBuffer outboundBuffer() {
        return this.outboundBuffer;
    }

    @Override
    public final SocketAddress localAddress() {
        return this.this$0.localAddress0();
    }

    @Override
    public final SocketAddress remoteAddress() {
        return this.this$0.remoteAddress0();
    }

    @Override
    public final void register(EventLoop eventLoop, ChannelPromise channelPromise) {
        if (eventLoop == null) {
            throw new NullPointerException("eventLoop");
        }
        if (this.this$0.isRegistered()) {
            channelPromise.setFailure(new IllegalStateException("registered to an event loop already"));
            return;
        }
        if (!this.this$0.isCompatible(eventLoop)) {
            channelPromise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
            return;
        }
        AbstractChannel.access$102(this.this$0, eventLoop);
        if (eventLoop.inEventLoop()) {
            this.register0(channelPromise);
            return;
        }
        try {
            eventLoop.execute(new AbstractChannel$AbstractUnsafe$1(this, channelPromise));
            return;
        }
        catch (Throwable throwable) {
            AbstractChannel.access$300().warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)this.this$0, (Object)throwable);
            this.closeForcibly();
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetFailure(channelPromise, throwable);
            return;
        }
    }

    private void register0(ChannelPromise channelPromise) {
        try {
            block8: {
                block7: {
                    if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                        return;
                    }
                    boolean bl = this.neverRegistered;
                    this.this$0.doRegister();
                    this.neverRegistered = false;
                    AbstractChannel.access$002(this.this$0, true);
                    AbstractChannel.access$500(this.this$0).invokeHandlerAddedIfNeeded();
                    this.safeSetSuccess(channelPromise);
                    AbstractChannel.access$500(this.this$0).fireChannelRegistered();
                    if (!this.this$0.isActive()) break block7;
                    if (bl) break block8;
                    if (this.this$0.config().isAutoRead()) {
                        this.beginRead();
                    }
                }
                return;
            }
            AbstractChannel.access$500(this.this$0).fireChannelActive();
        }
        catch (Throwable throwable) {
            this.closeForcibly();
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetFailure(channelPromise, throwable);
        }
    }

    @Override
    public final void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        this.assertEventLoop();
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        if (Boolean.TRUE.equals(this.this$0.config().getOption(ChannelOption.SO_BROADCAST)) && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.isRoot()) {
            AbstractChannel.access$300().warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + socketAddress + ") anyway as requested.");
        }
        boolean bl = this.this$0.isActive();
        try {
            this.this$0.doBind(socketAddress);
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            this.closeIfClosed();
            return;
        }
        if (!bl && this.this$0.isActive()) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$2(this));
        }
        this.safeSetSuccess(channelPromise);
    }

    @Override
    public final void disconnect(ChannelPromise channelPromise) {
        this.assertEventLoop();
        if (!channelPromise.setUncancellable()) {
            return;
        }
        boolean bl = this.this$0.isActive();
        try {
            this.this$0.doDisconnect();
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            this.closeIfClosed();
            return;
        }
        if (bl && !this.this$0.isActive()) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$3(this));
        }
        this.safeSetSuccess(channelPromise);
        this.closeIfClosed();
    }

    @Override
    public final void close(ChannelPromise channelPromise) {
        this.assertEventLoop();
        this.close(channelPromise, AbstractChannel.access$600(), AbstractChannel.access$600(), false);
    }

    private void close(ChannelPromise channelPromise, Throwable throwable, ClosedChannelException closedChannelException, boolean bl) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            if (!(channelPromise instanceof VoidChannelPromise)) {
                AbstractChannel.access$400(this.this$0).addListener((GenericFutureListener)new AbstractChannel$AbstractUnsafe$4(this, channelPromise));
            }
            return;
        }
        if (AbstractChannel.access$400(this.this$0).isDone()) {
            this.safeSetSuccess(channelPromise);
            return;
        }
        boolean bl2 = this.this$0.isActive();
        this.outboundBuffer = null;
        Executor executor = this.prepareToClose();
        if (executor != null) {
            executor.execute(new AbstractChannel$AbstractUnsafe$5(this, channelPromise, channelOutboundBuffer, throwable, bl, closedChannelException, bl2));
            return;
        }
        try {
            this.doClose0(channelPromise);
        }
        finally {
            channelOutboundBuffer.failFlushed(throwable, bl);
            channelOutboundBuffer.close(closedChannelException);
        }
        if (this.inFlush0) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$6(this, bl2));
            return;
        }
        this.fireChannelInactiveAndDeregister(bl2);
    }

    private void doClose0(ChannelPromise channelPromise) {
        try {
            this.this$0.doClose();
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetSuccess(channelPromise);
            return;
        }
        catch (Throwable throwable) {
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetFailure(channelPromise, throwable);
            return;
        }
    }

    private void fireChannelInactiveAndDeregister(boolean bl) {
        AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe = this;
        abstractChannel$AbstractUnsafe.deregister(abstractChannel$AbstractUnsafe.voidPromise(), bl && !this.this$0.isActive());
    }

    @Override
    public final void closeForcibly() {
        this.assertEventLoop();
        try {
            this.this$0.doClose();
            return;
        }
        catch (Exception exception) {
            AbstractChannel.access$300().warn("Failed to close a channel.", exception);
            return;
        }
    }

    @Override
    public final void deregister(ChannelPromise channelPromise) {
        this.assertEventLoop();
        this.deregister(channelPromise, false);
    }

    private void deregister(ChannelPromise channelPromise, boolean bl) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (!AbstractChannel.access$000(this.this$0)) {
            this.safeSetSuccess(channelPromise);
            return;
        }
        this.invokeLater(new AbstractChannel$AbstractUnsafe$7(this, bl, channelPromise));
    }

    @Override
    public final void beginRead() {
        this.assertEventLoop();
        if (!this.this$0.isActive()) {
            return;
        }
        try {
            this.this$0.doBeginRead();
            return;
        }
        catch (Exception exception) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$8(this, exception));
            AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe = this;
            abstractChannel$AbstractUnsafe.close(abstractChannel$AbstractUnsafe.voidPromise());
            return;
        }
    }

    @Override
    public final void write(Object object, ChannelPromise channelPromise) {
        int n2;
        this.assertEventLoop();
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            this.safeSetFailure(channelPromise, AbstractChannel.access$1000());
            ReferenceCountUtil.release(object);
            return;
        }
        try {
            object = this.this$0.filterOutboundMessage(object);
            n2 = AbstractChannel.access$500(this.this$0).estimatorHandle().size(object);
            if (n2 < 0) {
                n2 = 0;
            }
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            ReferenceCountUtil.release(object);
            return;
        }
        channelOutboundBuffer.addMessage(object, n2, channelPromise);
    }

    @Override
    public final void flush() {
        this.assertEventLoop();
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            return;
        }
        channelOutboundBuffer.addFlush();
        this.flush0();
    }

    public void flush0() {
        if (this.inFlush0) {
            return;
        }
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null || channelOutboundBuffer.isEmpty()) {
            return;
        }
        this.inFlush0 = true;
        if (!this.this$0.isActive()) {
            try {
                if (this.this$0.isOpen()) {
                    channelOutboundBuffer.failFlushed(AbstractChannel.access$1100(), true);
                } else {
                    channelOutboundBuffer.failFlushed(AbstractChannel.access$1200(), false);
                }
                return;
            }
            finally {
                this.inFlush0 = false;
            }
        }
        try {
            this.this$0.doWrite(channelOutboundBuffer);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof IOException && this.this$0.config().isAutoClose()) {
                AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe = this;
                abstractChannel$AbstractUnsafe.close(abstractChannel$AbstractUnsafe.voidPromise(), throwable2, AbstractChannel.access$1200(), false);
            } else {
                channelOutboundBuffer.failFlushed(throwable2, true);
            }
            return;
        }
        finally {
            this.inFlush0 = false;
        }
    }

    @Override
    public final ChannelPromise voidPromise() {
        this.assertEventLoop();
        return AbstractChannel.access$1300(this.this$0);
    }

    @Deprecated
    protected final boolean ensureOpen(ChannelPromise channelPromise) {
        if (this.this$0.isOpen()) {
            return true;
        }
        this.safeSetFailure(channelPromise, AbstractChannel.access$1400());
        return false;
    }

    public final void safeSetSuccess(ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
            AbstractChannel.access$300().warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
        }
    }

    public final void safeSetFailure(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            AbstractChannel.access$300().warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    public final void closeIfClosed() {
        if (this.this$0.isOpen()) {
            return;
        }
        AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe = this;
        abstractChannel$AbstractUnsafe.close(abstractChannel$AbstractUnsafe.voidPromise());
    }

    private void invokeLater(Runnable runnable) {
        try {
            this.this$0.eventLoop().execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AbstractChannel.access$300().warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
            return;
        }
    }

    protected final Throwable annotateConnectException(Throwable throwable, SocketAddress socketAddress) {
        if (throwable instanceof ConnectException) {
            return new AbstractChannel$AnnotatedConnectException((ConnectException)throwable, socketAddress);
        }
        if (throwable instanceof NoRouteToHostException) {
            return new AbstractChannel$AnnotatedNoRouteToHostException((NoRouteToHostException)throwable, socketAddress);
        }
        if (throwable instanceof SocketException) {
            return new AbstractChannel$AnnotatedSocketException((SocketException)throwable, socketAddress);
        }
        return throwable;
    }

    public Executor prepareToClose() {
        return null;
    }

    static /* synthetic */ void access$200(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, ChannelPromise channelPromise) {
        abstractChannel$AbstractUnsafe.register0(channelPromise);
    }

    static /* synthetic */ void access$700(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, ChannelPromise channelPromise) {
        abstractChannel$AbstractUnsafe.doClose0(channelPromise);
    }

    static /* synthetic */ void access$800(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, boolean bl) {
        abstractChannel$AbstractUnsafe.fireChannelInactiveAndDeregister(bl);
    }

    static /* synthetic */ void access$900(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, Runnable runnable) {
        abstractChannel$AbstractUnsafe.invokeLater(runnable);
    }

    static {
        $assertionsDisabled = !AbstractChannel.class.desiredAssertionStatus();
    }
}

