/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$CloseFuture;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.Channel$Unsafe;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelProgressivePromise;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelProgressivePromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.FailedChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.SucceededChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.VoidChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.DefaultAttributeMap;
import com.aliyun.openservices.shade.io.netty.util.internal.ThreadLocalRandom;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private static final ClosedChannelException FLUSH0_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractChannel$AbstractUnsafe.class, "flush0()");
    private static final ClosedChannelException ENSURE_OPEN_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractChannel$AbstractUnsafe.class, "ensureOpen(...)");
    private static final ClosedChannelException CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractChannel$AbstractUnsafe.class, "close(...)");
    private static final ClosedChannelException WRITE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractChannel$AbstractUnsafe.class, "write(...)");
    private static final NotYetConnectedException FLUSH0_NOT_YET_CONNECTED_EXCEPTION = ThrowableUtil.unknownStackTrace(new NotYetConnectedException(), AbstractChannel$AbstractUnsafe.class, "flush0()");
    private final Channel parent;
    private final long hashCode = ThreadLocalRandom.current().nextLong();
    private final Channel$Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final ChannelFuture succeededFuture = new SucceededChannelFuture(this, null);
    private final VoidChannelPromise voidPromise = new VoidChannelPromise(this, true);
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final AbstractChannel$CloseFuture closeFuture = new AbstractChannel$CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean strValActive;
    private String strVal;

    public AbstractChannel(Channel channel) {
        this.parent = channel;
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    @Override
    public boolean isWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null && channelOutboundBuffer.isWritable();
    }

    @Override
    public Channel parent() {
        return this.parent;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress socketAddress = this.localAddress;
        if (socketAddress == null) {
            try {
                this.localAddress = socketAddress = this.unsafe().localAddress();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateLocalAddress() {
        this.localAddress = null;
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            try {
                this.remoteAddress = socketAddress = this.unsafe().remoteAddress();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateRemoteAddress() {
        this.remoteAddress = null;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline.bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline.connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline.connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    @Override
    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline.close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline.deregister(channelPromise);
    }

    @Override
    public Channel read() {
        this.pipeline.read();
        return this;
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.pipeline.write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline.write(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline.writeAndFlush(object);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline.writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this);
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this);
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this, null, throwable);
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel$Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractChannel$AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return (int)this.hashCode;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        long l2 = this.hashCode - (long)channel.hashCode();
        if (l2 > 0L) {
            return 1;
        }
        if (l2 < 0L) {
            return -1;
        }
        l2 = System.identityHashCode(this) - System.identityHashCode(channel);
        if (l2 != 0L) {
            return (int)l2;
        }
        throw new Error();
    }

    public String toString() {
        boolean bl = this.isActive();
        if (this.strValActive == bl && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress socketAddress = this.remoteAddress();
        SocketAddress socketAddress2 = this.localAddress();
        if (socketAddress != null) {
            String string = bl ? "-" : "!";
            this.strVal = String.format("[id: 0x%08x, L:%s %s R:%s]", (int)this.hashCode, socketAddress2, string, socketAddress);
        } else {
            this.strVal = socketAddress2 != null ? String.format("[id: 0x%08x, L:%s]", (int)this.hashCode, socketAddress2) : String.format("[id: 0x%08x]", (int)this.hashCode);
        }
        this.strValActive = bl;
        return this.strVal;
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.voidPromise;
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected void doRegister() {
    }

    protected abstract void doBind(SocketAddress var1);

    protected abstract void doDisconnect();

    protected abstract void doClose();

    protected void doDeregister() {
    }

    protected abstract void doBeginRead();

    protected abstract void doWrite(ChannelOutboundBuffer var1);

    protected Object filterOutboundMessage(Object object) {
        return object;
    }

    static /* synthetic */ boolean access$000(AbstractChannel abstractChannel) {
        return abstractChannel.registered;
    }

    static /* synthetic */ EventLoop access$100(AbstractChannel abstractChannel) {
        return abstractChannel.eventLoop;
    }

    static /* synthetic */ EventLoop access$102(AbstractChannel abstractChannel, EventLoop eventLoop) {
        abstractChannel.eventLoop = eventLoop;
        return abstractChannel.eventLoop;
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static /* synthetic */ AbstractChannel$CloseFuture access$400(AbstractChannel abstractChannel) {
        return abstractChannel.closeFuture;
    }

    static /* synthetic */ boolean access$002(AbstractChannel abstractChannel, boolean bl) {
        abstractChannel.registered = bl;
        return abstractChannel.registered;
    }

    static /* synthetic */ DefaultChannelPipeline access$500(AbstractChannel abstractChannel) {
        return abstractChannel.pipeline;
    }

    static /* synthetic */ ClosedChannelException access$600() {
        return CLOSE_CLOSED_CHANNEL_EXCEPTION;
    }

    static /* synthetic */ ClosedChannelException access$1000() {
        return WRITE_CLOSED_CHANNEL_EXCEPTION;
    }

    static /* synthetic */ NotYetConnectedException access$1100() {
        return FLUSH0_NOT_YET_CONNECTED_EXCEPTION;
    }

    static /* synthetic */ ClosedChannelException access$1200() {
        return FLUSH0_CLOSED_CHANNEL_EXCEPTION;
    }

    static /* synthetic */ VoidChannelPromise access$1300(AbstractChannel abstractChannel) {
        return abstractChannel.unsafeVoidPromise;
    }

    static /* synthetic */ ClosedChannelException access$1400() {
        return ENSURE_OPEN_CLOSED_CHANNEL_EXCEPTION;
    }
}

