/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$CloseFuture;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$1;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$10;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$11;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$12;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$13;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$14;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$15;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$16;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$2;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$3;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$4;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$5;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$6;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$7;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$8;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$9;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$AbstractWriteTask;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$WriteAndFlushTask;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext$WriteTask;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelProgressivePromise;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelProgressivePromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.FailedChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.SucceededChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.VoidChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.DefaultAttributeMap;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.OrderedEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.PromiseNotificationUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext {
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER;
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final boolean inbound;
    private final boolean outbound;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private Runnable invokeChannelReadCompleteTask;
    private Runnable invokeReadTask;
    private Runnable invokeChannelWritableStateChangedTask;
    private Runnable invokeFlushTask;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, boolean bl, boolean bl2) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.inbound = bl;
        this.outbound = bl2;
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound());
        return this;
    }

    static void invokeChannelRegistered(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$1(abstractChannelHandlerContext));
    }

    private void invokeChannelRegistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRegistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelRegistered();
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound());
        return this;
    }

    static void invokeChannelUnregistered(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$2(abstractChannelHandlerContext));
    }

    private void invokeChannelUnregistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelUnregistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelUnregistered();
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound();
        AbstractChannelHandlerContext.invokeChannelActive(abstractChannelHandlerContext);
        return this;
    }

    static void invokeChannelActive(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$3(abstractChannelHandlerContext));
    }

    private void invokeChannelActive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelActive(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelActive();
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound());
        return this;
    }

    static void invokeChannelInactive(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$4(abstractChannelHandlerContext));
    }

    private void invokeChannelInactive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelInactive(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelInactive();
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.next, throwable);
        return this;
    }

    static void invokeExceptionCaught(AbstractChannelHandlerContext abstractChannelHandlerContext, Throwable throwable) {
        ObjectUtil.checkNotNull(throwable, "cause");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            return;
        }
        try {
            eventExecutor.execute(new AbstractChannelHandlerContext$5(abstractChannelHandlerContext, throwable));
            return;
        }
        catch (Throwable throwable2) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                DefaultChannelPipeline.logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
            }
            return;
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        block5: {
            if (this.invokeHandler()) {
                try {
                    this.handler().exceptionCaught(this, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    if (DefaultChannelPipeline.logger.isDebugEnabled()) {
                        DefaultChannelPipeline.logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                        break block5;
                    }
                    if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                        DefaultChannelPipeline.logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                    }
                    return;
                }
            }
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(), object);
        return this;
    }

    static void invokeUserEventTriggered(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        ObjectUtil.checkNotNull(object, "event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$6(abstractChannelHandlerContext, object));
    }

    private void invokeUserEventTriggered(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).userEventTriggered(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireUserEventTriggered(object);
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(), object);
        return this;
    }

    static void invokeChannelRead(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        ObjectUtil.checkNotNull(object, "msg");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object);
            return;
        }
        eventExecutor.execute(new AbstractChannelHandlerContext$7(abstractChannelHandlerContext, object));
    }

    private void invokeChannelRead(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRead(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelRead(object);
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound());
        return this;
    }

    static void invokeChannelReadComplete(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
            return;
        }
        Runnable runnable = abstractChannelHandlerContext.invokeChannelReadCompleteTask;
        if (runnable == null) {
            abstractChannelHandlerContext.invokeChannelReadCompleteTask = runnable = new AbstractChannelHandlerContext$8(abstractChannelHandlerContext);
        }
        eventExecutor.execute(runnable);
    }

    private void invokeChannelReadComplete() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelReadComplete(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelReadComplete();
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound());
        return this;
    }

    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
            return;
        }
        Runnable runnable = abstractChannelHandlerContext.invokeChannelWritableStateChangedTask;
        if (runnable == null) {
            abstractChannelHandlerContext.invokeChannelWritableStateChangedTask = runnable = new AbstractChannelHandlerContext$9(abstractChannelHandlerContext);
        }
        eventExecutor.execute(runnable);
    }

    private void invokeChannelWritabilityChanged() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelWritabilityChanged(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.fireChannelWritabilityChanged();
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.bind(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.connect(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.connect(socketAddress, socketAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.disconnect(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture close() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.close(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.deregister(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (socketAddress == null) {
            throw new NullPointerException("localAddress");
        }
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$10(this, abstractChannelHandlerContext, socketAddress, channelPromise), channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress serializable, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).bind(this, (SocketAddress)serializable, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.bind((SocketAddress)serializable, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$11(this, abstractChannelHandlerContext, socketAddress, socketAddress2, channelPromise), channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress serializable, SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).connect(this, (SocketAddress)serializable, socketAddress, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.connect((SocketAddress)serializable, socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (!this.channel().metadata().hasDisconnect()) {
                abstractChannelHandlerContext.invokeClose(channelPromise);
            } else {
                abstractChannelHandlerContext.invokeDisconnect(channelPromise);
            }
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$12(this, abstractChannelHandlerContext, channelPromise), channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).disconnect(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$13(this, abstractChannelHandlerContext, channelPromise), channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).close(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$14(this, abstractChannelHandlerContext, channelPromise), channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).deregister(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.deregister(channelPromise);
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeReadTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeReadTask = runnable = new AbstractChannelHandlerContext$15(this, abstractChannelHandlerContext);
            }
            eventExecutor.execute(runnable);
        }
        return this;
    }

    private void invokeRead() {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).read(this);
                return;
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
                return;
            }
        }
        this.read();
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        if (object == null) {
            throw new NullPointerException("msg");
        }
        try {
            if (!this.validatePromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return channelPromise;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    private void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            return;
        }
        this.write(object, channelPromise);
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        try {
            ((ChannelOutboundHandler)this.handler()).write(this, object, channelPromise);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            return;
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeFlushTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeFlushTask = runnable = new AbstractChannelHandlerContext$16(this, abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, runnable, this.channel().voidPromise(), null);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
            return;
        }
        this.flush();
    }

    private void invokeFlush0() {
        try {
            ((ChannelOutboundHandler)this.handler()).flush(this);
            return;
        }
        catch (Throwable throwable) {
            this.notifyHandlerException(throwable);
            return;
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        if (object == null) {
            throw new NullPointerException("msg");
        }
        if (!this.validatePromise(channelPromise, true)) {
            ReferenceCountUtil.release(object);
            return channelPromise;
        }
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    private void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
            return;
        }
        this.writeAndFlush(object, channelPromise);
    }

    private void write(Object object, boolean bl, ChannelPromise channelPromise) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (bl) {
                abstractChannelHandlerContext.invokeWriteAndFlush(object, channelPromise);
                return;
            }
            abstractChannelHandlerContext.invokeWrite(object, channelPromise);
            return;
        }
        AbstractChannelHandlerContext$AbstractWriteTask abstractChannelHandlerContext$AbstractWriteTask = bl ? AbstractChannelHandlerContext$WriteAndFlushTask.access$1600(abstractChannelHandlerContext, object, channelPromise) : AbstractChannelHandlerContext$WriteTask.access$1700(abstractChannelHandlerContext, object, channelPromise);
        AbstractChannelHandlerContext.safeExecute(eventExecutor, abstractChannelHandlerContext$AbstractWriteTask, channelPromise, object);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise)) {
            PromiseNotificationUtil.tryFailure(channelPromise, throwable, DefaultChannelPipeline.logger);
        }
    }

    private void notifyHandlerException(Throwable throwable) {
        if (AbstractChannelHandlerContext.inExceptionCaught(throwable)) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", throwable);
            }
            return;
        }
        this.invokeExceptionCaught(throwable);
    }

    private static boolean inExceptionCaught(Throwable throwable) {
        do {
            StackTraceElement stackTraceElement;
            StackTraceElement[] stackTraceElementArray;
            if ((stackTraceElementArray = throwable.getStackTrace()) == null) continue;
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2 && (stackTraceElement = stackTraceElementArray[i2]) != null; ++i2) {
                if (!"exceptionCaught".equals(stackTraceElement.getMethodName())) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture channelFuture = this.succeededFuture;
        if (channelFuture == null) {
            this.succeededFuture = channelFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean validatePromise(ChannelPromise channelPromise, boolean bl) {
        if (channelPromise == null) {
            throw new NullPointerException("promise");
        }
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return false;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return true;
        }
        if (!bl && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel$CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel$CloseFuture.class) + " not allowed in a pipeline");
        }
        return true;
    }

    private AbstractChannelHandlerContext findContextInbound() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        do {
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        } while (!abstractChannelHandlerContext.inbound);
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        do {
            abstractChannelHandlerContext = abstractChannelHandlerContext.prev;
        } while (!abstractChannelHandlerContext.outbound);
        return abstractChannelHandlerContext;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final void setAddComplete() {
        int n2;
        while ((n2 = this.handlerState) != 3 && !HANDLER_STATE_UPDATER.compareAndSet(this, n2, 2)) {
        }
    }

    final void setAddPending() {
        boolean bl = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl);
    }

    private boolean invokeHandler() {
        int n2 = this.handlerState;
        return n2 == 2 || !this.ordered && n2 == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object) {
        try {
            eventExecutor.execute(runnable);
            return;
        }
        catch (Throwable throwable) {
            try {
                channelPromise.setFailure(throwable);
                if (object == null) return;
            }
            catch (Throwable throwable2) {
                if (object == null) throw throwable2;
                ReferenceCountUtil.release(object);
                throw throwable2;
            }
            ReferenceCountUtil.release(object);
            return;
        }
    }

    static /* synthetic */ void access$000(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelRegistered();
    }

    static /* synthetic */ void access$100(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelUnregistered();
    }

    static /* synthetic */ void access$200(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelActive();
    }

    static /* synthetic */ void access$300(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelInactive();
    }

    static /* synthetic */ void access$400(AbstractChannelHandlerContext abstractChannelHandlerContext, Throwable throwable) {
        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
    }

    static /* synthetic */ void access$500(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        abstractChannelHandlerContext.invokeUserEventTriggered(object);
    }

    static /* synthetic */ void access$600(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        abstractChannelHandlerContext.invokeChannelRead(object);
    }

    static /* synthetic */ void access$700(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelReadComplete();
    }

    static /* synthetic */ void access$800(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelWritabilityChanged();
    }

    static /* synthetic */ void access$900(AbstractChannelHandlerContext abstractChannelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
    }

    static /* synthetic */ void access$1000(AbstractChannelHandlerContext abstractChannelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
    }

    static /* synthetic */ void access$1100(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeClose(channelPromise);
    }

    static /* synthetic */ void access$1200(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeDisconnect(channelPromise);
    }

    static /* synthetic */ void access$1300(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeDeregister(channelPromise);
    }

    static /* synthetic */ void access$1400(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeRead();
    }

    static /* synthetic */ void access$1500(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeFlush();
    }

    static /* synthetic */ DefaultChannelPipeline access$1800(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        return abstractChannelHandlerContext.pipeline;
    }

    static /* synthetic */ void access$1900(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeWrite(object, channelPromise);
    }

    static {
        AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(AbstractChannelHandlerContext.class, "handlerState");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
        }
        HANDLER_STATE_UPDATER = atomicIntegerFieldUpdater;
    }
}

