/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler$Sharable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;

@ChannelHandler$Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);
    private final ConcurrentMap<ChannelHandlerContext, Boolean> initMap = PlatformDependent.newConcurrentHashMap();

    protected abstract void initChannel(C var1);

    @Override
    public final void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (this.initChannel(channelHandlerContext)) {
            channelHandlerContext.pipeline().fireChannelRegistered();
            return;
        }
        channelHandlerContext.fireChannelRegistered();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("Failed to initialize a channel. Closing: " + channelHandlerContext.channel(), throwable);
        channelHandlerContext.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isRegistered()) {
            this.initChannel(channelHandlerContext);
        }
    }

    private boolean initChannel(ChannelHandlerContext channelHandlerContext) {
        if (this.initMap.putIfAbsent(channelHandlerContext, Boolean.TRUE) == null) {
            try {
                this.initChannel(channelHandlerContext.channel());
            }
            catch (Throwable throwable) {
                ((ChannelHandlerAdapter)this).exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                this.remove(channelHandlerContext);
            }
            return true;
        }
        return false;
    }

    private void remove(ChannelHandlerContext channelHandlerContext) {
        try {
            ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
            if (channelPipeline.context(this) != null) {
                channelPipeline.remove(this);
            }
            return;
        }
        finally {
            this.initMap.remove(channelHandlerContext);
        }
    }
}

