/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufHolder;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$1;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$2;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$3;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$Entry;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelProgressivePromise;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.channel.VoidChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.PromiseNotificationUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new ChannelOutboundBuffer$1();
    private final Channel channel;
    private ChannelOutboundBuffer$Entry flushedEntry;
    private ChannelOutboundBuffer$Entry unflushedEntry;
    private ChannelOutboundBuffer$Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER;
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER;
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public final void addMessage(Object object, int n2, ChannelPromise object2) {
        object = ChannelOutboundBuffer$Entry.newInstance(object, n2, ChannelOutboundBuffer.total(object), (ChannelPromise)object2);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
            this.tailEntry = object;
        } else {
            object2 = this.tailEntry;
            this.tailEntry.next = object;
            this.tailEntry = object;
        }
        if (this.unflushedEntry == null) {
            this.unflushedEntry = object;
        }
        this.incrementPendingOutboundBytes(n2, false);
    }

    public final void addFlush() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry;
        if (channelOutboundBuffer$Entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = channelOutboundBuffer$Entry;
            }
            do {
                ++this.flushed;
                if (channelOutboundBuffer$Entry.promise.setUncancellable()) continue;
                int n2 = channelOutboundBuffer$Entry.cancel();
                this.decrementPendingOutboundBytes(n2, false, true);
            } while ((channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    final void incrementPendingOutboundBytes(long l2) {
        this.incrementPendingOutboundBytes(l2, true);
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l3 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl);
        }
    }

    final void decrementPendingOutboundBytes(long l2) {
        this.decrementPendingOutboundBytes(l2, true, true);
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl, boolean bl2) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (bl2 && l3 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public final Object current() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return null;
        }
        return channelOutboundBuffer$Entry.msg;
    }

    public final void progress(long l2) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        assert (channelOutboundBuffer$Entry != null);
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        if (channelPromise instanceof ChannelProgressivePromise) {
            long l3;
            channelOutboundBuffer$Entry.progress = l3 = channelOutboundBuffer$Entry.progress + l2;
            ((ChannelProgressivePromise)channelPromise).tryProgress(l3, channelOutboundBuffer$Entry.total);
        }
    }

    public final boolean remove() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n2 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n2, false, true);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    public final boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n2 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n2, false, bl);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    private void removeEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (channelOutboundBuffer$Entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
                return;
            }
        } else {
            this.flushedEntry = channelOutboundBuffer$Entry.next;
        }
    }

    public final void removeBytes(long l2) {
        block5: {
            int n2;
            Object object;
            while (true) {
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l2 == 0L);
                    break block5;
                }
                object = (ByteBuf)object;
                n2 = ((ByteBuf)object).readerIndex();
                int n3 = ((ByteBuf)object).writerIndex() - n2;
                if ((long)n3 > l2) break;
                if (l2 != 0L) {
                    this.progress(n3);
                    l2 -= (long)n3;
                }
                this.remove();
            }
            if (l2 != 0L) {
                ((ByteBuf)object).readerIndex(n2 + (int)l2);
                this.progress(l2);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n2 = this.nioBufferCount;
        if (n2 > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n2, null);
        }
    }

    public final ByteBuffer[] nioBuffers() {
        long l2 = 0L;
        int n2 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        while (this.isFlushedEntry(channelOutboundBuffer$Entry) && channelOutboundBuffer$Entry.msg instanceof ByteBuf) {
            if (!channelOutboundBuffer$Entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)channelOutboundBuffer$Entry.msg;
                int n3 = byteBuf.readerIndex();
                int n4 = byteBuf.writerIndex() - n3;
                if (n4 > 0) {
                    Object object;
                    int n5;
                    if ((long)(Integer.MAX_VALUE - n4) < l2) break;
                    l2 += (long)n4;
                    int n6 = channelOutboundBuffer$Entry.count;
                    if (n6 == -1) {
                        channelOutboundBuffer$Entry.count = n6 = byteBuf.nioBufferCount();
                    }
                    if ((n5 = n2 + n6) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n5, n2);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n6 == 1) {
                        object = channelOutboundBuffer$Entry.buf;
                        if (channelOutboundBuffer$Entry.buf == null) {
                            object = byteBuf.internalNioBuffer(n3, n4);
                            channelOutboundBuffer$Entry.buf = object;
                        }
                        byteBufferArray[n2++] = object;
                    } else {
                        object = channelOutboundBuffer$Entry.bufs;
                        if (channelOutboundBuffer$Entry.bufs == null) {
                            object = byteBuf.nioBuffers();
                            channelOutboundBuffer$Entry.bufs = object;
                        }
                        n2 = ChannelOutboundBuffer.fillBufferArray(object, byteBufferArray, n2);
                    }
                }
            }
            channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next;
        }
        this.nioBufferCount = n2;
        this.nioBufferSize = l2;
        return byteBufferArray;
    }

    private static int fillBufferArray(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2, int n2) {
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (byteBuffer == null) break;
            byteBufferArray2[n2++] = byteBuffer;
        }
        return n2;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n2, int n3) {
        int n4 = byteBufferArray.length;
        do {
            if ((n4 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n2 > n4);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n3);
        return byteBufferArray2;
    }

    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    public final long nioBufferSize() {
        return this.nioBufferSize;
    }

    public final boolean isWritable() {
        return this.unwritable == 0;
    }

    public final boolean getUserDefinedWritability(int n2) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n2)) == 0;
    }

    public final void setUserDefinedWritability(int n2, boolean bl) {
        if (bl) {
            this.setUserDefinedWritability(n2);
            return;
        }
        this.clearUserDefinedWritability(n2);
    }

    private void setUserDefinedWritability(int n2) {
        int n3;
        int n4;
        n2 = ~ChannelOutboundBuffer.writabilityMask(n2);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n4 = this.unwritable, n3 = n4 & n2)) {
        }
        if (n4 != 0 && n3 == 0) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    private void clearUserDefinedWritability(int n2) {
        int n3;
        int n4;
        n2 = ChannelOutboundBuffer.writabilityMask(n2);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n4 = this.unwritable, n3 = n4 | n2)) {
        }
        if (n4 == 0 && n3 != 0) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    private static int writabilityMask(int n2) {
        if (n2 <= 0 || n2 > 31) {
            throw new IllegalArgumentException("index: " + n2 + " (expected: 1~31)");
        }
        return 1 << n2;
    }

    private void setWritable(boolean bl) {
        int n2;
        int n3;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & 0xFFFFFFFE)) {
        }
        if (n3 != 0 && n2 == 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void setUnwritable(boolean bl) {
        int n2;
        int n3;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | 1)) {
        }
        if (n3 == 0 && n2 != 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void fireChannelWritabilityChanged(boolean bl) {
        ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new ChannelOutboundBuffer$2(this, channelPipeline);
            }
            this.channel.eventLoop().execute(runnable);
            return;
        }
        channelPipeline.fireChannelWritabilityChanged();
    }

    public final int size() {
        return this.flushed;
    }

    public final boolean isEmpty() {
        return this.flushed == 0;
    }

    final void failFlushed(Throwable throwable, boolean bl) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl)) {
            }
            return;
        }
        finally {
            this.inFail = false;
        }
    }

    final void close(ClosedChannelException closedChannelException) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new ChannelOutboundBuffer$3(this, closedChannelException));
            return;
        }
        this.inFail = true;
        if (this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry; channelOutboundBuffer$Entry != null; channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.recycleAndGetNext()) {
                int n2 = channelOutboundBuffer$Entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n2);
                if (channelOutboundBuffer$Entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(channelOutboundBuffer$Entry.msg);
                ChannelOutboundBuffer.safeFail(channelOutboundBuffer$Entry.promise, closedChannelException);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise)) {
            PromiseNotificationUtil.trySuccess(channelPromise, null, logger);
        }
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise)) {
            PromiseNotificationUtil.tryFailure(channelPromise, throwable, logger);
        }
    }

    @Deprecated
    public final void recycle() {
    }

    public final long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public final long bytesBeforeUnwritable() {
        long l2 = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l2 > 0L) {
            if (this.isWritable()) {
                return l2;
            }
            return 0L;
        }
        return 0L;
    }

    public final long bytesBeforeWritable() {
        long l2 = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (l2 > 0L) {
            if (this.isWritable()) {
                return 0L;
            }
            return l2;
        }
        return 0L;
    }

    public final void forEachFlushedMessage(ChannelOutboundBuffer$MessageProcessor channelOutboundBuffer$MessageProcessor) {
        if (channelOutboundBuffer$MessageProcessor == null) {
            throw new NullPointerException("processor");
        }
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return;
        }
        do {
            if (channelOutboundBuffer$Entry.cancelled || channelOutboundBuffer$MessageProcessor.processMessage(channelOutboundBuffer$Entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next));
    }

    private boolean isFlushedEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        return channelOutboundBuffer$Entry != null && channelOutboundBuffer$Entry != this.unflushedEntry;
    }

    static {
        AtomicLongFieldUpdater<ChannelOutboundBuffer> atomicLongFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(ChannelOutboundBuffer.class, "unwritable");
        if (atomicLongFieldUpdater == null) {
            atomicLongFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
        }
        UNWRITABLE_UPDATER = atomicLongFieldUpdater;
        atomicLongFieldUpdater = PlatformDependent.newAtomicLongFieldUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        if (atomicLongFieldUpdater == null) {
            atomicLongFieldUpdater = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        }
        TOTAL_PENDING_SIZE_UPDATER = atomicLongFieldUpdater;
    }
}

