/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.AbstractChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipelineException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$1;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$2;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$3;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$4;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$5;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$6;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$7;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$8;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$9;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$HeadContext;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$PendingHandlerAddedTask;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$PendingHandlerCallback;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$PendingHandlerRemovedTask;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline$TailContext;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator$Handle;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(DefaultChannelPipeline$HeadContext.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(DefaultChannelPipeline$TailContext.class);
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new DefaultChannelPipeline$1();
    final AbstractChannelHandlerContext head;
    final AbstractChannelHandlerContext tail;
    private final Channel channel;
    private Map<EventExecutorGroup, EventExecutor> childExecutors;
    private MessageSizeEstimator$Handle estimatorHandle;
    private boolean firstRegistration = true;
    private DefaultChannelPipeline$PendingHandlerCallback pendingHandlerCallbackHead;
    private boolean registered;

    public DefaultChannelPipeline(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        DefaultChannelPipeline defaultChannelPipeline = this;
        this.tail = new DefaultChannelPipeline$TailContext(defaultChannelPipeline, defaultChannelPipeline);
        DefaultChannelPipeline defaultChannelPipeline2 = this;
        this.head = new DefaultChannelPipeline$HeadContext(defaultChannelPipeline2, defaultChannelPipeline2);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    final MessageSizeEstimator$Handle estimatorHandle() {
        if (this.estimatorHandle == null) {
            this.estimatorHandle = this.channel.config().getMessageSizeEstimator().newHandle();
        }
        return this.estimatorHandle;
    }

    private AbstractChannelHandlerContext newContext(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return new DefaultChannelHandlerContext(defaultChannelPipeline, defaultChannelPipeline.childExecutor(eventExecutorGroup), string, channelHandler);
    }

    private EventExecutor childExecutor(EventExecutorGroup eventExecutorGroup) {
        EventExecutor eventExecutor;
        if (eventExecutorGroup == null) {
            return null;
        }
        Object object = this.channel.config().getOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP);
        if (object != null && !((Boolean)object).booleanValue()) {
            return eventExecutorGroup.next();
        }
        object = this.childExecutors;
        if (object == null) {
            this.childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>(4);
            object = this.childExecutors;
        }
        if ((eventExecutor = (EventExecutor)object.get(eventExecutorGroup)) == null) {
            eventExecutor = eventExecutorGroup.next();
            object.put((EventExecutorGroup)eventExecutorGroup, (EventExecutor)eventExecutor);
        }
        return eventExecutor;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public final ChannelPipeline addFirst(String string, ChannelHandler channelHandler) {
        return this.addFirst(null, string, channelHandler);
    }

    @Override
    public final ChannelPipeline addFirst(EventExecutorGroup object, String object2, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            object2 = this.filterName((String)object2, channelHandler);
            object = this.newContext((EventExecutorGroup)object, (String)object2, channelHandler);
            this.addFirst0((AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                object2.execute(new DefaultChannelPipeline$2(this, (AbstractChannelHandlerContext)object));
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private void addFirst0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.head.next;
        abstractChannelHandlerContext.prev = this.head;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
        this.head.next = abstractChannelHandlerContext;
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext;
    }

    @Override
    public final ChannelPipeline addLast(String string, ChannelHandler channelHandler) {
        return this.addLast(null, string, channelHandler);
    }

    @Override
    public final ChannelPipeline addLast(EventExecutorGroup object, String object2, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            object = this.newContext((EventExecutorGroup)object, this.filterName((String)object2, channelHandler), channelHandler);
            this.addLast0((AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                object2.execute(new DefaultChannelPipeline$3(this, (AbstractChannelHandlerContext)object));
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private void addLast0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2 = this.tail.prev;
        abstractChannelHandlerContext.next = this.tail;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        this.tail.prev = abstractChannelHandlerContext;
    }

    @Override
    public final ChannelPipeline addBefore(String string, String string2, ChannelHandler channelHandler) {
        return this.addBefore(null, string, string2, channelHandler);
    }

    @Override
    public final ChannelPipeline addBefore(EventExecutorGroup object, String object2, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            string = this.filterName(string, channelHandler);
            object2 = this.getContextOrDie((String)object2);
            object = this.newContext((EventExecutorGroup)object, string, channelHandler);
            DefaultChannelPipeline.addBefore0((AbstractChannelHandlerContext)object2, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                object2.execute(new DefaultChannelPipeline$4(this, (AbstractChannelHandlerContext)object));
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private static void addBefore0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        abstractChannelHandlerContext.prev.next = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
    }

    private String filterName(String string, ChannelHandler channelHandler) {
        if (string == null) {
            return this.generateName(channelHandler);
        }
        this.checkDuplicateName(string);
        return string;
    }

    @Override
    public final ChannelPipeline addAfter(String string, String string2, ChannelHandler channelHandler) {
        return this.addAfter(null, string, string2, channelHandler);
    }

    @Override
    public final ChannelPipeline addAfter(EventExecutorGroup object, String object2, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            string = this.filterName(string, channelHandler);
            object2 = this.getContextOrDie((String)object2);
            object = this.newContext((EventExecutorGroup)object, string, channelHandler);
            DefaultChannelPipeline.addAfter0((AbstractChannelHandlerContext)object2, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                object2.execute(new DefaultChannelPipeline$5(this, (AbstractChannelHandlerContext)object));
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private static void addAfter0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext.next.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
    }

    @Override
    public final ChannelPipeline addFirst(ChannelHandler ... channelHandlerArray) {
        return this.addFirst((EventExecutorGroup)null, channelHandlerArray);
    }

    @Override
    public final ChannelPipeline addFirst(EventExecutorGroup eventExecutorGroup, ChannelHandler ... channelHandlerArray) {
        int n2;
        if (channelHandlerArray == null) {
            throw new NullPointerException("handlers");
        }
        if (channelHandlerArray.length == 0 || channelHandlerArray[0] == null) {
            return this;
        }
        for (n2 = 1; n2 < channelHandlerArray.length && channelHandlerArray[n2] != null; ++n2) {
        }
        --n2;
        while (n2 >= 0) {
            ChannelHandler channelHandler = channelHandlerArray[n2];
            this.addFirst(eventExecutorGroup, (String)null, channelHandler);
            --n2;
        }
        return this;
    }

    @Override
    public final ChannelPipeline addLast(ChannelHandler ... channelHandlerArray) {
        return this.addLast((EventExecutorGroup)null, channelHandlerArray);
    }

    @Override
    public final ChannelPipeline addLast(EventExecutorGroup eventExecutorGroup, ChannelHandler ... channelHandlerArray) {
        if (channelHandlerArray == null) {
            throw new NullPointerException("handlers");
        }
        for (ChannelHandler channelHandler : channelHandlerArray) {
            if (channelHandler == null) break;
            this.addLast(eventExecutorGroup, (String)null, channelHandler);
        }
        return this;
    }

    private String generateName(ChannelHandler object) {
        Map<Class<?>, String> map = nameCaches.get();
        String string = map.get(object = object.getClass());
        if (string == null) {
            string = DefaultChannelPipeline.generateName0(object);
            map.put((Class<?>)object, string);
        }
        if (this.context0(string) != null) {
            object = string.substring(0, string.length() - 1);
            int n2 = 1;
            while (this.context0(string = (String)object + n2) != null) {
                ++n2;
            }
        }
        return string;
    }

    private static String generateName0(Class<?> clazz) {
        return StringUtil.simpleClassName(clazz) + "#0";
    }

    @Override
    public final ChannelPipeline remove(ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie(channelHandler));
        return this;
    }

    @Override
    public final ChannelHandler remove(String string) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie(string)).handler();
    }

    @Override
    public final <T extends ChannelHandler> T remove(Class<T> clazz) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return (T)defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie(clazz)).handler();
    }

    private AbstractChannelHandlerContext remove(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        assert (abstractChannelHandlerContext != this.head && abstractChannelHandlerContext != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.remove0(abstractChannelHandlerContext);
            if (!this.registered) {
                this.callHandlerCallbackLater(abstractChannelHandlerContext, false);
                return abstractChannelHandlerContext;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!eventExecutor.inEventLoop()) {
                eventExecutor.execute(new DefaultChannelPipeline$6(this, abstractChannelHandlerContext));
                return abstractChannelHandlerContext;
            }
        }
        this.callHandlerRemoved0(abstractChannelHandlerContext);
        return abstractChannelHandlerContext;
    }

    private static void remove0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
    }

    @Override
    public final ChannelHandler removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.head.next).handler();
    }

    @Override
    public final ChannelHandler removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.tail.prev).handler();
    }

    @Override
    public final ChannelPipeline replace(ChannelHandler channelHandler, String string, ChannelHandler channelHandler2) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie(channelHandler), string, channelHandler2);
        return this;
    }

    @Override
    public final ChannelHandler replace(String string, String string2, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie(string), string2, channelHandler);
    }

    @Override
    public final <T extends ChannelHandler> T replace(Class<T> clazz, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return (T)defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie(clazz), string, channelHandler);
    }

    private ChannelHandler replace(AbstractChannelHandlerContext abstractChannelHandlerContext, String object, ChannelHandler object2) {
        assert (abstractChannelHandlerContext != this.head && abstractChannelHandlerContext != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity((ChannelHandler)object2);
            boolean bl = abstractChannelHandlerContext.name().equals(object);
            if (!bl) {
                this.checkDuplicateName((String)object);
            }
            object = this.newContext(abstractChannelHandlerContext.executor, (String)object, (ChannelHandler)object2);
            DefaultChannelPipeline.replace0(abstractChannelHandlerContext, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                this.callHandlerCallbackLater(abstractChannelHandlerContext, false);
                return abstractChannelHandlerContext.handler();
            }
            object2 = abstractChannelHandlerContext.executor();
            if (!object2.inEventLoop()) {
                object2.execute(new DefaultChannelPipeline$7(this, (AbstractChannelHandlerContext)object, abstractChannelHandlerContext));
                return abstractChannelHandlerContext.handler();
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        this.callHandlerRemoved0(abstractChannelHandlerContext);
        return abstractChannelHandlerContext.handler();
    }

    private static void replace0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext3 = abstractChannelHandlerContext.prev;
        AbstractChannelHandlerContext abstractChannelHandlerContext4 = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext3;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext4;
        abstractChannelHandlerContext3.next = abstractChannelHandlerContext2;
        abstractChannelHandlerContext4.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
    }

    private static void checkMultiplicity(ChannelHandler channelHandler) {
        if (channelHandler instanceof ChannelHandlerAdapter) {
            if (!((ChannelHandlerAdapter)(channelHandler = (ChannelHandlerAdapter)channelHandler)).isSharable() && ((ChannelHandlerAdapter)channelHandler).added) {
                throw new ChannelPipelineException(channelHandler.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            ((ChannelHandlerAdapter)channelHandler).added = true;
        }
    }

    private void callHandlerAdded0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            abstractChannelHandlerContext.handler().handlerAdded(abstractChannelHandlerContext);
            abstractChannelHandlerContext.setAddComplete();
            return;
        }
        catch (Throwable throwable) {
            boolean bl;
            block9: {
                bl = false;
                try {
                    DefaultChannelPipeline.remove0(abstractChannelHandlerContext);
                    try {
                        abstractChannelHandlerContext.handler().handlerRemoved(abstractChannelHandlerContext);
                    }
                    finally {
                        abstractChannelHandlerContext.setRemoved();
                    }
                    bl = true;
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to remove a handler: " + abstractChannelHandlerContext.name(), throwable2);
                }
            }
            if (bl) {
                this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", throwable));
                return;
            }
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", throwable));
            return;
        }
    }

    private void callHandlerRemoved0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            try {
                abstractChannelHandlerContext.handler().handlerRemoved(abstractChannelHandlerContext);
            }
            finally {
                abstractChannelHandlerContext.setRemoved();
            }
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", throwable));
        }
    }

    final void invokeHandlerAddedIfNeeded() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.firstRegistration) {
            this.firstRegistration = false;
            this.callHandlerAddedForAllHandlers();
        }
    }

    @Override
    public final ChannelHandler first() {
        ChannelHandlerContext channelHandlerContext = this.firstContext();
        if (channelHandlerContext == null) {
            return null;
        }
        return channelHandlerContext.handler();
    }

    @Override
    public final ChannelHandlerContext firstContext() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        if (abstractChannelHandlerContext == this.tail) {
            return null;
        }
        return this.head.next;
    }

    @Override
    public final ChannelHandler last() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.tail.prev;
        if (abstractChannelHandlerContext == this.head) {
            return null;
        }
        return abstractChannelHandlerContext.handler();
    }

    @Override
    public final ChannelHandlerContext lastContext() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.tail.prev;
        if (abstractChannelHandlerContext == this.head) {
            return null;
        }
        return abstractChannelHandlerContext;
    }

    @Override
    public final ChannelHandler get(String object) {
        if ((object = this.context((String)object)) == null) {
            return null;
        }
        return object.handler();
    }

    @Override
    public final <T extends ChannelHandler> T get(Class<T> object) {
        if ((object = this.context((Class<? extends ChannelHandler>)object)) == null) {
            return null;
        }
        return (T)object.handler();
    }

    @Override
    public final ChannelHandlerContext context(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return this.context0(string);
    }

    @Override
    public final ChannelHandlerContext context(ChannelHandler channelHandler) {
        if (channelHandler == null) {
            throw new NullPointerException("handler");
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (abstractChannelHandlerContext.handler() == channelHandler) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> clazz) {
        if (clazz == null) {
            throw new NullPointerException("handlerType");
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (clazz.isAssignableFrom(abstractChannelHandlerContext.handler().getClass())) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final List<String> names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            arrayList.add(abstractChannelHandlerContext.name());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return arrayList;
    }

    @Override
    public final Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> linkedHashMap = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            linkedHashMap.put(abstractChannelHandlerContext.name(), abstractChannelHandlerContext.handler());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return linkedHashMap;
    }

    @Override
    public final Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append('{');
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            stringBuilder.append('(').append(abstractChannelHandlerContext.name()).append(" = ").append(abstractChannelHandlerContext.handler().getClass().getName()).append(')');
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            if (abstractChannelHandlerContext == this.tail) break;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.head);
        return this;
    }

    private synchronized void destroy() {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.destroyUp(defaultChannelPipeline.head.next, false);
    }

    private void destroyUp(AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        Thread thread = Thread.currentThread();
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.tail;
        while (true) {
            if (abstractChannelHandlerContext == abstractChannelHandlerContext2) {
                this.destroyDown(thread, abstractChannelHandlerContext2.prev, bl);
                return;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!bl && !eventExecutor.inEventLoop(thread)) {
                eventExecutor.execute(new DefaultChannelPipeline$8(this, abstractChannelHandlerContext));
                return;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            bl = false;
        }
    }

    private void destroyDown(Thread thread, AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.head;
        while (abstractChannelHandlerContext != abstractChannelHandlerContext2) {
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (bl || eventExecutor.inEventLoop(thread)) {
                DefaultChannelPipeline defaultChannelPipeline = this;
                synchronized (defaultChannelPipeline) {
                    DefaultChannelPipeline.remove0(abstractChannelHandlerContext);
                }
            } else {
                AbstractChannelHandlerContext abstractChannelHandlerContext3 = abstractChannelHandlerContext;
                eventExecutor.execute(new DefaultChannelPipeline$9(this, abstractChannelHandlerContext3));
                return;
            }
            this.callHandlerRemoved0(abstractChannelHandlerContext);
            abstractChannelHandlerContext = abstractChannelHandlerContext.prev;
            bl = false;
        }
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.head, throwable);
        return this;
    }

    @Override
    public final ChannelPipeline fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.head);
        return this;
    }

    @Override
    public final ChannelFuture bind(SocketAddress socketAddress) {
        return this.tail.bind(socketAddress);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress) {
        return this.tail.connect(socketAddress);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.tail.connect(socketAddress, socketAddress2);
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.tail.disconnect();
    }

    @Override
    public final ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public final ChannelFuture deregister() {
        return this.tail.deregister();
    }

    @Override
    public final ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public final ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.tail.bind(socketAddress, channelPromise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, channelPromise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.tail.disconnect(channelPromise);
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        return this.tail.close(channelPromise);
    }

    @Override
    public final ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.tail.deregister(channelPromise);
    }

    @Override
    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public final ChannelFuture write(Object object) {
        return this.tail.write(object);
    }

    @Override
    public final ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.tail.write(object, channelPromise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.tail.writeAndFlush(object, channelPromise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object object) {
        return this.tail.writeAndFlush(object);
    }

    private void checkDuplicateName(String string) {
        if (this.context0(string) != null) {
            throw new IllegalArgumentException("Duplicate handler name: " + string);
        }
    }

    private AbstractChannelHandlerContext context0(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            if (abstractChannelHandlerContext.name().equals(string)) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    private AbstractChannelHandlerContext getContextOrDie(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(string);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(string);
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler channelHandler) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(channelHandler);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(channelHandler.getClass().getName());
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> clazz) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(clazz);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(clazz.getName());
        }
        return abstractChannelHandlerContext;
    }

    private void callHandlerAddedForAllHandlers() {
        DefaultChannelPipeline$PendingHandlerCallback defaultChannelPipeline$PendingHandlerCallback;
        Object object = this;
        synchronized (object) {
            assert (!this.registered);
            this.registered = true;
            defaultChannelPipeline$PendingHandlerCallback = this.pendingHandlerCallbackHead;
            this.pendingHandlerCallbackHead = null;
        }
        object = defaultChannelPipeline$PendingHandlerCallback;
        while (object != null) {
            ((DefaultChannelPipeline$PendingHandlerCallback)object).execute();
            object = ((DefaultChannelPipeline$PendingHandlerCallback)object).next;
        }
    }

    private void callHandlerCallbackLater(AbstractChannelHandlerContext object, boolean bl) {
        assert (!this.registered);
        object = bl ? new DefaultChannelPipeline$PendingHandlerAddedTask(this, (AbstractChannelHandlerContext)object) : new DefaultChannelPipeline$PendingHandlerRemovedTask(this, (AbstractChannelHandlerContext)object);
        DefaultChannelPipeline$PendingHandlerCallback defaultChannelPipeline$PendingHandlerCallback = this.pendingHandlerCallbackHead;
        if (defaultChannelPipeline$PendingHandlerCallback == null) {
            this.pendingHandlerCallbackHead = object;
            return;
        }
        while (defaultChannelPipeline$PendingHandlerCallback.next != null) {
            defaultChannelPipeline$PendingHandlerCallback = defaultChannelPipeline$PendingHandlerCallback.next;
        }
        defaultChannelPipeline$PendingHandlerCallback.next = object;
    }

    protected void onUnhandledInboundException(Throwable throwable) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", throwable);
            return;
        }
        finally {
            ReferenceCountUtil.release(throwable);
        }
    }

    protected void onUnhandledInboundMessage(Object object) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", object);
            return;
        }
        finally {
            ReferenceCountUtil.release(object);
        }
    }

    static /* synthetic */ void access$000(DefaultChannelPipeline defaultChannelPipeline, AbstractChannelHandlerContext abstractChannelHandlerContext) {
        defaultChannelPipeline.callHandlerAdded0(abstractChannelHandlerContext);
    }

    static /* synthetic */ void access$100(DefaultChannelPipeline defaultChannelPipeline, AbstractChannelHandlerContext abstractChannelHandlerContext) {
        defaultChannelPipeline.callHandlerRemoved0(abstractChannelHandlerContext);
    }

    static /* synthetic */ void access$200(DefaultChannelPipeline defaultChannelPipeline, AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        defaultChannelPipeline.destroyUp(abstractChannelHandlerContext, bl);
    }

    static /* synthetic */ void access$300(DefaultChannelPipeline defaultChannelPipeline, Thread thread, AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        defaultChannelPipeline.destroyDown(thread, abstractChannelHandlerContext, bl);
    }

    static /* synthetic */ String access$400() {
        return TAIL_NAME;
    }

    static /* synthetic */ String access$500() {
        return HEAD_NAME;
    }

    static /* synthetic */ Channel access$600(DefaultChannelPipeline defaultChannelPipeline) {
        return defaultChannelPipeline.channel;
    }

    static /* synthetic */ void access$700(DefaultChannelPipeline defaultChannelPipeline) {
        defaultChannelPipeline.destroy();
    }

    static /* synthetic */ void access$800(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        DefaultChannelPipeline.remove0(abstractChannelHandlerContext);
    }
}

