/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.util.AbstractReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.IllegalReferenceCountException;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final File f;
    private final long position;
    private final long count;
    private long transfered;
    private FileChannel file;

    public DefaultFileRegion(FileChannel fileChannel, long l2, long l3) {
        if (fileChannel == null) {
            throw new NullPointerException("file");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("position must be >= 0 but was " + l2);
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("count must be >= 0 but was " + l3);
        }
        this.file = fileChannel;
        this.position = l2;
        this.count = l3;
        this.f = null;
    }

    public DefaultFileRegion(File file, long l2, long l3) {
        if (file == null) {
            throw new NullPointerException("f");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("position must be >= 0 but was " + l2);
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("count must be >= 0 but was " + l3);
        }
        this.position = l2;
        this.count = l3;
        this.f = file;
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() {
        if (!this.isOpen() && this.refCnt() > 0) {
            this.file = new RandomAccessFile(this.f, "r").getChannel();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long transfered() {
        return this.transfered;
    }

    @Override
    public long transferTo(WritableByteChannel writableByteChannel, long l2) {
        long l3 = this.count - l2;
        if (l3 < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position out of range: " + l2 + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (l3 == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long l4 = this.file.transferTo(this.position + l2, l3, writableByteChannel);
        if (l4 > 0L) {
            this.transfered += l4;
        }
        return l4;
    }

    @Override
    public void deallocate() {
        FileChannel fileChannel = this.file;
        if (fileChannel == null) {
            return;
        }
        this.file = null;
        try {
            fileChannel.close();
            return;
        }
        catch (IOException iOException) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to close a file.", iOException);
            }
            return;
        }
    }
}

