/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultThreadFactory;
import com.aliyun.openservices.shade.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.eventLoopThreads", Runtime.getRuntime().availableProcessors() << 1));

    public MultithreadEventLoopGroup(int n2, ThreadFactory threadFactory, Object ... objectArray) {
        super(n2 == 0 ? DEFAULT_EVENT_LOOP_THREADS : n2, threadFactory, objectArray);
    }

    @Override
    public ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return this.next().register(channel, channelPromise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

