/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.PendingWriteQueue$PendingWrite;
import com.aliyun.openservices.shade.io.netty.channel.VoidChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.PromiseCombiner;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private final ChannelHandlerContext ctx;
    private final ChannelOutboundBuffer buffer;
    private final MessageSizeEstimator$Handle estimatorHandle;
    private PendingWriteQueue$PendingWrite head;
    private PendingWriteQueue$PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext == null) {
            throw new NullPointerException("ctx");
        }
        this.ctx = channelHandlerContext;
        this.buffer = channelHandlerContext.channel().unsafe().outboundBuffer();
        this.estimatorHandle = channelHandlerContext.channel().config().getMessageSizeEstimator().newHandle();
    }

    public final boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public final int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public final long bytes() {
        assert (this.ctx.executor().inEventLoop());
        return this.bytes;
    }

    public final void add(Object object, ChannelPromise object2) {
        assert (this.ctx.executor().inEventLoop());
        if (object == null) {
            throw new NullPointerException("msg");
        }
        if (object2 == null) {
            throw new NullPointerException("promise");
        }
        int n2 = this.estimatorHandle.size(object);
        if (n2 < 0) {
            n2 = 0;
        }
        object = PendingWriteQueue$PendingWrite.newInstance(object, n2, (ChannelPromise)object2);
        object2 = this.tail;
        if (object2 == null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = pendingWriteQueue.head = object;
        } else {
            PendingWriteQueue$PendingWrite.access$002((PendingWriteQueue$PendingWrite)object2, (PendingWriteQueue$PendingWrite)object);
            this.tail = object;
        }
        ++this.size;
        this.bytes += (long)n2;
        if (this.buffer != null) {
            this.buffer.incrementPendingOutboundBytes(PendingWriteQueue$PendingWrite.access$100((PendingWriteQueue$PendingWrite)object));
        }
    }

    public final ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.ctx.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner();
        try {
            PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
            while (pendingWriteQueue$PendingWrite != null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWriteQueue$PendingWrite != null) {
                    PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                    Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
                    ChannelPromise channelPromise2 = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                    this.recycle(pendingWriteQueue$PendingWrite, false);
                    promiseCombiner.add(channelPromise2);
                    this.ctx.write(object, channelPromise2);
                    pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
                }
                pendingWriteQueue$PendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public final void removeAndFailAll(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        while (pendingWriteQueue$PendingWrite != null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = null;
            pendingWriteQueue.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWriteQueue$PendingWrite != null) {
                PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
                ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                this.recycle(pendingWriteQueue$PendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
            }
            pendingWriteQueue$PendingWrite = this.head;
        }
        this.assertEmpty();
    }

    public final void removeAndFail(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        PendingWriteQueue.safeFail(channelPromise, throwable);
        this.recycle(pendingWriteQueue$PendingWrite, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public final ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return this.ctx.write(object, channelPromise);
    }

    public final ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return channelPromise;
    }

    public final Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        return PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
    }

    private void recycle(PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite, boolean bl) {
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
        long l2 = PendingWriteQueue$PendingWrite.access$100(pendingWriteQueue$PendingWrite);
        if (bl) {
            if (pendingWriteQueue$PendingWrite2 == null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWriteQueue$PendingWrite2;
                --this.size;
                this.bytes -= l2;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        PendingWriteQueue$PendingWrite.access$400(pendingWriteQueue$PendingWrite);
        if (this.buffer != null) {
            this.buffer.decrementPendingOutboundBytes(l2);
        }
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }
}

