/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;

public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    public SimpleChannelInboundHandler() {
        this(true);
    }

    protected SimpleChannelInboundHandler(boolean bl) {
        this.matcher = TypeParameterMatcher.find(this, SimpleChannelInboundHandler.class, "I");
        this.autoRelease = bl;
    }

    protected SimpleChannelInboundHandler(Class<? extends I> clazz) {
        this(clazz, true);
    }

    protected SimpleChannelInboundHandler(Class<? extends I> clazz, boolean bl) {
        this.matcher = TypeParameterMatcher.get(clazz);
        this.autoRelease = bl;
    }

    public boolean acceptInboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        boolean bl = true;
        try {
            if (this.acceptInboundMessage(object)) {
                Object object2 = object;
                this.channelRead0(channelHandlerContext, object2);
            } else {
                bl = false;
                channelHandlerContext.fireChannelRead(object);
            }
            if (!this.autoRelease || !bl) return;
        }
        catch (Throwable throwable) {
            if (!this.autoRelease || !bl) throw throwable;
            ReferenceCountUtil.release(object);
            throw throwable;
        }
        ReferenceCountUtil.release(object);
    }

    protected abstract void channelRead0(ChannelHandlerContext var1, I var2);
}

