/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.FailedChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ThreadPerChannelEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.ThreadPerChannelEventLoopGroup$1;
import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultPromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FutureListener;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GlobalEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ReadOnlyIterator;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadPerChannelEventLoopGroup
extends AbstractEventExecutorGroup
implements EventLoopGroup {
    private final Object[] childArgs;
    private final int maxChannels;
    final ThreadFactory threadFactory;
    final Set<ThreadPerChannelEventLoop> activeChildren = Collections.newSetFromMap(PlatformDependent.newConcurrentHashMap());
    final Queue<ThreadPerChannelEventLoop> idleChildren = new ConcurrentLinkedQueue<ThreadPerChannelEventLoop>();
    private final ChannelException tooManyChannels;
    private volatile boolean shuttingDown;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final FutureListener<Object> childTerminationListener = new ThreadPerChannelEventLoopGroup$1(this);

    protected ThreadPerChannelEventLoopGroup() {
        this(0);
    }

    protected ThreadPerChannelEventLoopGroup(int n2) {
        this(n2, Executors.defaultThreadFactory(), new Object[0]);
    }

    public ThreadPerChannelEventLoopGroup(int n2, ThreadFactory threadFactory, Object ... objectArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("maxChannels: %d (expected: >= 0)", n2));
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        this.childArgs = objectArray == null ? EmptyArrays.EMPTY_OBJECTS : (Object[])objectArray.clone();
        this.maxChannels = n2;
        this.threadFactory = threadFactory;
        this.tooManyChannels = ThrowableUtil.unknownStackTrace(new ChannelException("too many channels (max: " + n2 + ')'), ThreadPerChannelEventLoopGroup.class, "nextChild()");
    }

    protected ThreadPerChannelEventLoop newChild(Object ... objectArray) {
        return new ThreadPerChannelEventLoop(this);
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return new ReadOnlyIterator<EventExecutor>(this.activeChildren.iterator());
    }

    @Override
    public EventLoop next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        this.shuttingDown = true;
        for (EventLoop eventLoop : this.activeChildren) {
            eventLoop.shutdownGracefully(l2, l3, timeUnit);
        }
        for (EventLoop eventLoop : this.idleChildren) {
            eventLoop.shutdownGracefully(l2, l3, timeUnit);
        }
        if (this.isTerminated()) {
            this.terminationFuture.trySuccess(null);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        this.shuttingDown = true;
        for (EventLoop eventLoop : this.activeChildren) {
            eventLoop.shutdown();
        }
        for (EventLoop eventLoop : this.idleChildren) {
            eventLoop.shutdown();
        }
        if (this.isTerminated()) {
            this.terminationFuture.trySuccess(null);
        }
    }

    @Override
    public boolean isShuttingDown() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isShuttingDown()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        long l3;
        long l4 = System.nanoTime() + timeUnit.toNanos(l2);
        block0: for (EventLoop eventLoop : this.activeChildren) {
            while ((l3 = l4 - System.nanoTime()) > 0L) {
                if (eventLoop.awaitTermination(l3, TimeUnit.NANOSECONDS)) continue block0;
            }
            return this.isTerminated();
        }
        block2: for (EventLoop eventLoop : this.idleChildren) {
            while ((l3 = l4 - System.nanoTime()) > 0L) {
                if (eventLoop.awaitTermination(l3, TimeUnit.NANOSECONDS)) continue block2;
            }
            return this.isTerminated();
        }
        return this.isTerminated();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        try {
            EventLoop eventLoop = this.nextChild();
            return eventLoop.register(channel, new DefaultChannelPromise(channel, eventLoop));
        }
        catch (Throwable throwable) {
            return new FailedChannelFuture(channel, GlobalEventExecutor.INSTANCE, throwable);
        }
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        try {
            return this.nextChild().register(channel, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    private EventLoop nextChild() {
        if (this.shuttingDown) {
            throw new RejectedExecutionException("shutting down");
        }
        ThreadPerChannelEventLoop threadPerChannelEventLoop = this.idleChildren.poll();
        if (threadPerChannelEventLoop == null) {
            if (this.maxChannels > 0 && this.activeChildren.size() >= this.maxChannels) {
                throw this.tooManyChannels;
            }
            ThreadPerChannelEventLoopGroup threadPerChannelEventLoopGroup = this;
            threadPerChannelEventLoop = threadPerChannelEventLoopGroup.newChild(threadPerChannelEventLoopGroup.childArgs);
            threadPerChannelEventLoop.terminationFuture().addListener(this.childTerminationListener);
        }
        this.activeChildren.add(threadPerChannelEventLoop);
        return threadPerChannelEventLoop;
    }

    static /* synthetic */ Promise access$000(ThreadPerChannelEventLoopGroup threadPerChannelEventLoopGroup) {
        return threadPerChannelEventLoopGroup.terminationFuture;
    }
}

