/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractFuture;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private final Channel channel;
    private final boolean fireException;

    VoidChannelPromise(Channel channel, boolean bl) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        this.fireException = bl;
    }

    @Override
    public final VoidChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        return this;
    }

    @Override
    public final VoidChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        return this;
    }

    @Override
    public final VoidChannelPromise await() {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    @Override
    public final boolean await(long l2, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final boolean await(long l2) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final VoidChannelPromise awaitUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final boolean awaitUninterruptibly(long l2, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final boolean awaitUninterruptibly(long l2) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public final boolean isDone() {
        return false;
    }

    @Override
    public final boolean isSuccess() {
        return false;
    }

    @Override
    public final boolean setUncancellable() {
        return true;
    }

    @Override
    public final boolean isCancellable() {
        return false;
    }

    @Override
    public final boolean isCancelled() {
        return false;
    }

    @Override
    public final Throwable cause() {
        return null;
    }

    @Override
    public final VoidChannelPromise sync() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise syncUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise setFailure(Throwable throwable) {
        this.fireException(throwable);
        return this;
    }

    @Override
    public final VoidChannelPromise setSuccess() {
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        this.fireException(throwable);
        return false;
    }

    @Override
    public final boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public final boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public final VoidChannelPromise setSuccess(Void void_) {
        return this;
    }

    @Override
    public final boolean trySuccess(Void void_) {
        return false;
    }

    @Override
    public final Void getNow() {
        return null;
    }

    private void fireException(Throwable throwable) {
        if (this.fireException && this.channel.isRegistered()) {
            this.channel.pipeline().fireExceptionCaught(throwable);
        }
    }
}

