/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.embedded;

import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.ChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel$DefaultUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel$EmbeddedChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedSocketAddress;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.RecyclableArrayList;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new EmbeddedChannel$1(this);
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private int state;

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(false, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, ChannelHandler ... channelHandlerArray) {
        super(null);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = new DefaultChannelConfig(this);
        this.setup(channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl) {
        if (bl) {
            return METADATA_DISCONNECT;
        }
        return METADATA_NO_DISCONNECT;
    }

    private void setup(ChannelHandler ... object) {
        ObjectUtil.checkNotNull(object, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new EmbeddedChannel$2(this, (ChannelHandler[])object));
        object = this.loop.register(this);
        assert (object.isDone());
    }

    @Override
    public final DefaultChannelPipeline newChannelPipeline() {
        EmbeddedChannel embeddedChannel = this;
        return new EmbeddedChannel$EmbeddedChannelPipeline(embeddedChannel, embeddedChannel);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public Object readInbound() {
        return EmbeddedChannel.poll(this.inboundMessages);
    }

    public Object readOutbound() {
        return EmbeddedChannel.poll(this.outboundMessages);
    }

    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline channelPipeline = this.pipeline();
        for (Object object : objectArray) {
            channelPipeline.fireChannelRead(object);
        }
        channelPipeline.fireChannelReadComplete();
        this.runPendingTasks();
        this.checkException();
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public boolean writeOutbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(objectArray.length);
        try {
            Object object;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2 && (object = objectArray[i2]) != null; ++i2) {
                recyclableArrayList.add(this.write(object));
            }
            this.runPendingTasks();
            this.flush();
            int n3 = recyclableArrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ChannelFuture channelFuture = (ChannelFuture)recyclableArrayList.get(n2);
                if (channelFuture.isDone()) {
                    this.recordException(channelFuture);
                    continue;
                }
                channelFuture.addListener(this.recordExceptionListener);
            }
            this.checkException();
            n2 = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n2 != 0;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl) {
        ((AbstractChannel)this).close();
        try {
            this.checkException();
            boolean bl2 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl2;
        }
        finally {
            if (bl) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl) {
        this.runPendingTasks();
        if (bl) {
            ((AbstractScheduledEventExecutor)this.loop).cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        EmbeddedChannel embeddedChannel = this;
        return ((AbstractChannel)embeddedChannel).close(embeddedChannel.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        EmbeddedChannel embeddedChannel = this;
        return ((AbstractChannel)embeddedChannel).disconnect(embeddedChannel.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelFuture) {
        this.runPendingTasks();
        channelFuture = super.close((ChannelPromise)channelFuture);
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelFuture) {
        channelFuture = super.disconnect((ChannelPromise)channelFuture);
        EmbeddedChannel embeddedChannel = this;
        embeddedChannel.finishPendingTasks(!embeddedChannel.metadata.hasDisconnect());
        return channelFuture;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        if (queue != null) {
            return queue.poll();
        }
        return null;
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.loop.runScheduledTasks();
            return;
        }
        catch (Exception exception) {
            this.recordException(exception);
            return;
        }
    }

    public long runScheduledPendingTasks() {
        try {
            return this.loop.runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
            return this.loop.nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
            return;
        }
        logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
    }

    public void checkException() {
        Throwable throwable = this.lastException;
        if (throwable == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(throwable);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    public SocketAddress localAddress0() {
        if (this.isActive()) {
            return this.localAddress;
        }
        return null;
    }

    @Override
    public SocketAddress remoteAddress0() {
        if (this.isActive()) {
            return this.remoteAddress;
        }
        return null;
    }

    @Override
    public void doRegister() {
        this.state = 1;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
    }

    @Override
    public void doDisconnect() {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    public void doClose() {
        this.state = 2;
    }

    @Override
    public void doBeginRead() {
    }

    @Override
    public AbstractChannel$AbstractUnsafe newUnsafe() {
        return new EmbeddedChannel$DefaultUnsafe(this, null);
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.outboundMessages().add(object);
            channelOutboundBuffer.remove();
        }
    }

    static /* synthetic */ void access$000(EmbeddedChannel embeddedChannel, ChannelFuture channelFuture) {
        embeddedChannel.recordException(channelFuture);
    }

    static /* synthetic */ void access$200(EmbeddedChannel embeddedChannel, Throwable throwable) {
        embeddedChannel.recordException(throwable);
    }
}

