/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import com.aliyun.openservices.shade.io.netty.channel.unix.UnixChannel;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata DATA = new ChannelMetadata(false);
    private final int readFlag;
    private final Socket fileDescriptor;
    protected int flags = Native.EPOLLET;
    protected volatile boolean active;

    AbstractEpollChannel(Socket socket, int n2) {
        this(null, socket, n2, false);
    }

    AbstractEpollChannel(Channel channel, Socket socket, int n2, boolean bl) {
        super(channel);
        this.fileDescriptor = ObjectUtil.checkNotNull(socket, "fd");
        this.readFlag = n2;
        this.flags |= n2;
        this.active = bl;
    }

    static boolean isSoErrorZero(Socket socket) {
        try {
            return socket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    void setFlag(int n2) {
        if (!this.isFlagSet(n2)) {
            this.flags |= n2;
            this.modifyEvents();
        }
    }

    void clearFlag(int n2) {
        if (this.isFlagSet(n2)) {
            this.flags &= ~n2;
            this.modifyEvents();
        }
    }

    boolean isFlagSet(int n2) {
        return (this.flags & n2) != 0;
    }

    @Override
    public final Socket fd() {
        return this.fileDescriptor;
    }

    @Override
    public abstract EpollChannelConfig config();

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return DATA;
    }

    @Override
    public void doClose() {
        this.active = false;
        try {
            this.doDeregister();
            return;
        }
        finally {
            this.fileDescriptor.close();
        }
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    public boolean isOpen() {
        return this.fileDescriptor.isOpen();
    }

    @Override
    public void doDeregister() {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    @Override
    public void doBeginRead() {
        ((AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe()).readPending = true;
        AbstractEpollChannel abstractEpollChannel = this;
        abstractEpollChannel.setFlag(abstractEpollChannel.readFlag);
    }

    /*
     * Enabled aggressive block sorting
     */
    final void clearEpollIn() {
        if (!this.isRegistered()) {
            this.flags &= ~this.readFlag;
            return;
        }
        EventLoop eventLoop = this.eventLoop();
        AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe();
        if (eventLoop.inEventLoop()) {
            abstractEpollChannel$AbstractEpollUnsafe.clearEpollIn0();
            return;
        }
        eventLoop.execute(new AbstractEpollChannel$1(this, abstractEpollChannel$AbstractEpollUnsafe));
    }

    private void modifyEvents() {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    @Override
    public void doRegister() {
        EpollEventLoop epollEventLoop = (EpollEventLoop)this.eventLoop();
        epollEventLoop.add(this);
    }

    @Override
    protected abstract AbstractEpollChannel$AbstractEpollUnsafe newUnsafe();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return this.newDirectBuffer(byteBuf2, byteBuf2);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.safeRelease(object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        ByteBuf byteBuf3 = byteBuf;
        byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator object2, int n2) {
        object2 = object2.directBuffer(n2);
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)object2).writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return object2;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.writerIndex();
        if (byteBuf.hasMemoryAddress()) {
            n2 = this.fileDescriptor.readAddress(byteBuf.memoryAddress(), n3, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = byteBuf.internalNioBuffer(n3, byteBuf.writableBytes());
            n2 = this.fileDescriptor.read(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
        }
        if (n2 > 0) {
            byteBuf.writerIndex(n3 + n2);
        }
        return n2;
    }

    protected final int doWriteBytes(ByteBuf byteBuf, int n2) {
        int n3 = byteBuf.readableBytes();
        int n4 = 0;
        if (byteBuf.hasMemoryAddress()) {
            int n5;
            long l2 = byteBuf.memoryAddress();
            int n6 = byteBuf.readerIndex();
            int n7 = byteBuf.writerIndex();
            --n2;
            while (n2 >= 0 && (n5 = this.fileDescriptor.writeAddress(l2, n6, n7)) > 0) {
                if ((n4 += n5) == n3) {
                    return n4;
                }
                n6 += n5;
                --n2;
            }
        } else {
            int n8;
            int n9;
            ByteBuffer byteBuffer;
            if (byteBuf.nioBufferCount() == 1) {
                ByteBuf byteBuf2 = byteBuf;
                byteBuffer = byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), byteBuf.readableBytes());
            } else {
                byteBuffer = byteBuf.nioBuffer();
            }
            for (int i2 = n2 - 1; i2 >= 0 && (n2 = this.fileDescriptor.write(byteBuffer, n9 = byteBuffer.position(), n8 = byteBuffer.limit())) > 0; --i2) {
                byteBuffer.position(n9 + n2);
                if ((n4 += n2) != n3) continue;
                return n4;
            }
        }
        if (n4 < n3) {
            this.setFlag(Native.EPOLLOUT);
        }
        return n4;
    }

    static /* synthetic */ int access$000(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.readFlag;
    }
}

