/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollStreamUnsafe$1;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollStreamUnsafe$2;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollStreamUnsafe$3;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInTask;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class AbstractEpollStreamChannel$EpollStreamUnsafe
extends AbstractEpollChannel$AbstractEpollUnsafe {
    private RecvByteBufAllocator$Handle allocHandle;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractEpollStreamChannel this$0;

    AbstractEpollStreamChannel$EpollStreamUnsafe(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        this.this$0 = abstractEpollStreamChannel;
        super(abstractEpollStreamChannel);
    }

    @Override
    public Executor prepareToClose() {
        return super.prepareToClose();
    }

    private boolean handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl || throwable instanceof IOException) {
            this.shutdownInput();
            return true;
        }
        return false;
    }

    @Override
    public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        try {
            if (AbstractEpollStreamChannel.access$200(this.this$0) != null) {
                throw new ConnectionPendingException();
            }
            boolean bl = this.this$0.isActive();
            if (!this.this$0.doConnect(socketAddress, socketAddress2)) {
                AbstractEpollStreamChannel.access$202(this.this$0, channelPromise);
                AbstractEpollStreamChannel.access$302(this.this$0, socketAddress);
                int n2 = this.this$0.config().getConnectTimeoutMillis();
                if (n2 > 0) {
                    AbstractEpollStreamChannel.access$402(this.this$0, this.this$0.eventLoop().schedule(new AbstractEpollStreamChannel$EpollStreamUnsafe$1(this, socketAddress), (long)n2, TimeUnit.MILLISECONDS));
                }
                channelPromise.addListener(new AbstractEpollStreamChannel$EpollStreamUnsafe$2(this));
                return;
            }
            this.fulfillConnectPromise(channelPromise, bl);
        }
        catch (Throwable throwable) {
            this.closeIfClosed();
            channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
        if (channelPromise == null) {
            return;
        }
        this.this$0.active = true;
        boolean bl2 = this.this$0.isActive();
        boolean bl3 = channelPromise.trySuccess();
        if (!bl && bl2) {
            this.this$0.pipeline().fireChannelActive();
        }
        if (!bl3) {
            AbstractEpollStreamChannel$EpollStreamUnsafe abstractEpollStreamChannel$EpollStreamUnsafe = this;
            abstractEpollStreamChannel$EpollStreamUnsafe.close(abstractEpollStreamChannel$EpollStreamUnsafe.voidPromise());
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
        if (channelPromise == null) {
            return;
        }
        channelPromise.tryFailure(throwable);
        this.closeIfClosed();
    }

    private void finishConnect() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        try {
            boolean bl = this.this$0.isActive();
            if (!this.doFinishConnect()) {
                return;
            }
            AbstractEpollStreamChannel$EpollStreamUnsafe abstractEpollStreamChannel$EpollStreamUnsafe = this;
            abstractEpollStreamChannel$EpollStreamUnsafe.fulfillConnectPromise(AbstractEpollStreamChannel.access$200(abstractEpollStreamChannel$EpollStreamUnsafe.this$0), bl);
            return;
        }
        catch (Throwable throwable) {
            AbstractEpollStreamChannel$EpollStreamUnsafe abstractEpollStreamChannel$EpollStreamUnsafe = this;
            abstractEpollStreamChannel$EpollStreamUnsafe.fulfillConnectPromise(AbstractEpollStreamChannel.access$200(abstractEpollStreamChannel$EpollStreamUnsafe.this$0), this.annotateConnectException(throwable, AbstractEpollStreamChannel.access$300(this.this$0)));
            return;
        }
        finally {
            if (AbstractEpollStreamChannel.access$400(this.this$0) != null) {
                AbstractEpollStreamChannel.access$400(this.this$0).cancel(false);
            }
            AbstractEpollStreamChannel.access$202(this.this$0, null);
        }
    }

    @Override
    void epollOutReady() {
        if (AbstractEpollStreamChannel.access$200(this.this$0) != null) {
            this.finishConnect();
            return;
        }
        super.epollOutReady();
    }

    boolean doFinishConnect() {
        if (this.this$0.fd().finishConnect()) {
            this.this$0.clearFlag(Native.EPOLLOUT);
            return true;
        }
        this.this$0.setFlag(Native.EPOLLOUT);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void epollInReady() {
        if (this.this$0.fd().isInputShutdown()) {
            return;
        }
        EpollChannelConfig epollChannelConfig = this.this$0.config();
        boolean bl = this.this$0.isFlagSet(Native.EPOLLET);
        if (!(this.readPending || bl || epollChannelConfig.isAutoRead())) {
            this.clearEpollIn0();
            return;
        }
        ChannelPipeline channelPipeline = this.this$0.pipeline();
        ByteBufAllocator byteBufAllocator = epollChannelConfig.getAllocator();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.allocHandle;
        if (recvByteBufAllocator$Handle == null) {
            this.allocHandle = recvByteBufAllocator$Handle = epollChannelConfig.getRecvByteBufAllocator().newHandle();
        }
        ByteBuf byteBuf = null;
        boolean bl2 = false;
        try {
            int n2 = bl ? Integer.MAX_VALUE : epollChannelConfig.getMaxMessagesPerRead();
            int n3 = 0;
            int n4 = 0;
            do {
                AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask;
                if (AbstractEpollStreamChannel.access$500(this.this$0) != null && (abstractEpollStreamChannel$SpliceInTask = (AbstractEpollStreamChannel$SpliceInTask)AbstractEpollStreamChannel.access$500(this.this$0).peek()) != null) {
                    if (!abstractEpollStreamChannel$SpliceInTask.spliceIn(recvByteBufAllocator$Handle)) break;
                    if (!this.this$0.isActive()) continue;
                    AbstractEpollStreamChannel.access$500(this.this$0).remove();
                    continue;
                }
                byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
                int n5 = byteBuf.writableBytes();
                int n6 = this.this$0.doReadBytes(byteBuf);
                if (n6 <= 0) {
                    byteBuf.release();
                    bl2 = n6 < 0;
                    break;
                }
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
                byteBuf = null;
                if (n4 >= Integer.MAX_VALUE - n6) {
                    recvByteBufAllocator$Handle.record(n4);
                    n4 = n6;
                } else {
                    n4 += n6;
                }
                if (n6 < n5 || !bl && !epollChannelConfig.isAutoRead() || this.this$0.fd().isInputShutdown()) break;
            } while (++n3 < n2 || this.isRdHup());
            channelPipeline.fireChannelReadComplete();
            recvByteBufAllocator$Handle.record(n4);
            if (bl2) {
                this.shutdownInput();
            }
            if (this.readPending || epollChannelConfig.isAutoRead()) return;
        }
        catch (Throwable throwable) {
            try {
                boolean bl3 = this.handleReadException(channelPipeline, byteBuf, throwable, bl2);
                if (bl3) return;
                this.this$0.eventLoop().execute(new AbstractEpollStreamChannel$EpollStreamUnsafe$3(this));
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (this.readPending || epollChannelConfig.isAutoRead()) return;
                this.clearEpollIn0();
            }
        }
        this.clearEpollIn0();
        return;
    }

    static {
        $assertionsDisabled = !AbstractEpollStreamChannel.class.desiredAssertionStatus();
    }
}

