/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultFileRegion;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$3;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$4;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollStreamUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SocketWritableByteChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceFdTask;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInChannelTask;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInTask;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceOutTask;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollMode;
import com.aliyun.openservices.shade.io.netty.channel.epoll.IovArray;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.socket.DuplexChannel;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "doClose()");
    private static final ClosedChannelException CLEAR_SPLICE_QUEUE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "clearSpliceQueue()");
    private static final ClosedChannelException SPLICE_TO_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "spliceTo(...)");
    private static final ClosedChannelException FAIL_SPLICE_IF_CLOSED_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "failSpliceIfClosed(...)");
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private Queue<AbstractEpollStreamChannel$SpliceInTask> spliceQueue;
    private FileDescriptor pipeIn;
    private FileDescriptor pipeOut;
    private WritableByteChannel byteChannel;

    @Deprecated
    protected AbstractEpollStreamChannel(Channel channel, int n2) {
        this(channel, new Socket(n2));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(int n2) {
        this(new Socket(n2));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(FileDescriptor fileDescriptor) {
        this(new Socket(fileDescriptor.intValue()));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(Socket socket) {
        Socket socket2 = socket;
        this(socket2, AbstractEpollStreamChannel.isSoErrorZero(socket2));
    }

    protected AbstractEpollStreamChannel(Channel channel, Socket socket) {
        super(channel, socket, Native.EPOLLIN, true);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(Socket socket, boolean bl) {
        super(null, socket, Native.EPOLLIN, bl);
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel$AbstractEpollUnsafe newUnsafe() {
        return new AbstractEpollStreamChannel$EpollStreamUnsafe(this);
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n2) {
        return this.spliceTo(abstractEpollStreamChannel, n2, this.newPromise());
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n2, ChannelPromise channelPromise) {
        if (abstractEpollStreamChannel.eventLoop() != this.eventLoop()) {
            throw new IllegalArgumentException("EventLoops are not the same.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len: " + n2 + " (expected: >= 0)");
        }
        if (abstractEpollStreamChannel.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED || this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(SPLICE_TO_CLOSED_CHANNEL_EXCEPTION);
        } else {
            this.addToSpliceQueue(new AbstractEpollStreamChannel$SpliceInChannelTask(this, abstractEpollStreamChannel, n2, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n2, int n3) {
        return this.spliceTo(fileDescriptor, n2, n3, this.newPromise());
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n2, int n3, ChannelPromise channelPromise) {
        if (n3 < 0) {
            throw new IllegalArgumentException("len: " + n3 + " (expected: >= 0)");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("offset must be >= 0 but was " + n2);
        }
        if (this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(SPLICE_TO_CLOSED_CHANNEL_EXCEPTION);
        } else {
            this.addToSpliceQueue(new AbstractEpollStreamChannel$SpliceFdTask(this, fileDescriptor, n2, n3, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    private void failSpliceIfClosed(ChannelPromise channelPromise) {
        if (!this.isOpen() && channelPromise.tryFailure(FAIL_SPLICE_IF_CLOSED_CLOSED_CHANNEL_EXCEPTION)) {
            this.eventLoop().execute(new AbstractEpollStreamChannel$1(this));
        }
    }

    private boolean writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBufferArray, int n2) {
        int n3 = byteBufferArray.readableBytes();
        if (n3 == 0) {
            channelOutboundBuffer.remove();
            return true;
        }
        if (byteBufferArray.hasMemoryAddress() || byteBufferArray.nioBufferCount() == 1) {
            int n4 = this.doWriteBytes((ByteBuf)byteBufferArray, n2);
            channelOutboundBuffer.removeBytes(n4);
            return n4 == n3;
        }
        byteBufferArray = byteBufferArray.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n3, n2);
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray, int n2) {
        long l2;
        long l3;
        long l4 = l3 = iovArray.size();
        int n3 = iovArray.count();
        assert (l3 != 0L);
        assert (n3 != 0);
        boolean bl = false;
        int n4 = 0;
        int n5 = n3 + 0;
        --n2;
        while (n2 >= 0 && (l2 = this.fd().writevAddresses(iovArray.memoryAddress(n4), n3)) != 0L) {
            long l5;
            if ((l3 -= l2) == 0L) {
                bl = true;
                break;
            }
            while ((l5 = iovArray.processWritten(n4, l2)) != -1L) {
                --n3;
                if (++n4 < n5 && (l2 -= l5) > 0L) continue;
            }
            --n2;
        }
        channelOutboundBuffer.removeBytes(l4 - l3);
        return bl;
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n2, long l2, int n3) {
        long l3;
        assert (l2 != 0L);
        long l4 = l2;
        boolean bl = false;
        int n4 = 0;
        int n5 = n2 + 0;
        --n3;
        while (n3 >= 0 && (l3 = this.fd().writev(byteBufferArray, n4, n2)) != 0L) {
            int n6;
            if ((l2 -= l3) == 0L) {
                bl = true;
                break;
            }
            do {
                ByteBuffer byteBuffer = byteBufferArray[n4];
                int n7 = byteBuffer.position();
                n6 = byteBuffer.limit() - n7;
                if ((long)n6 > l3) {
                    byteBuffer.position(n7 + (int)l3);
                    break;
                }
                --n2;
            } while (++n4 < n5 && (l3 -= (long)n6) > 0L);
            --n3;
        }
        channelOutboundBuffer.removeBytes(l4 - l2);
        return bl;
    }

    private boolean writeDefaultFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion, int n2) {
        long l2 = defaultFileRegion.count();
        if (defaultFileRegion.transfered() >= l2) {
            channelOutboundBuffer.remove();
            return true;
        }
        long l3 = defaultFileRegion.position();
        boolean bl = false;
        long l4 = 0L;
        --n2;
        while (n2 >= 0) {
            long l5 = defaultFileRegion.transfered();
            long l6 = Native.sendfile(this.fd().intValue(), defaultFileRegion, l3, l5, l2 - l5);
            if (l6 == 0L) break;
            l4 += l6;
            if (defaultFileRegion.transfered() >= l2) {
                bl = true;
                break;
            }
            --n2;
        }
        if (l4 > 0L) {
            channelOutboundBuffer.progress(l4);
        }
        if (bl) {
            channelOutboundBuffer.remove();
        }
        return bl;
    }

    private boolean writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, FileRegion fileRegion, int n2) {
        long l2;
        if (fileRegion.transfered() >= fileRegion.count()) {
            channelOutboundBuffer.remove();
            return true;
        }
        boolean bl = false;
        long l3 = 0L;
        if (this.byteChannel == null) {
            this.byteChannel = new AbstractEpollStreamChannel$SocketWritableByteChannel(this, null);
        }
        --n2;
        while (n2 >= 0 && (l2 = fileRegion.transferTo(this.byteChannel, fileRegion.transfered())) != 0L) {
            l3 += l2;
            if (fileRegion.transfered() >= fileRegion.count()) {
                bl = true;
                break;
            }
            --n2;
        }
        if (l3 > 0L) {
            channelOutboundBuffer.progress(l3);
        }
        if (bl) {
            channelOutboundBuffer.remove();
        }
        return bl;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        int n2 = this.config().getWriteSpinCount();
        while (true) {
            int n3;
            if ((n3 = channelOutboundBuffer.size()) == 0) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            if (n3 > 1 && channelOutboundBuffer.current() instanceof ByteBuf) {
                if (this.doWriteMultiple(channelOutboundBuffer, n2)) continue;
                break;
            }
            if (!this.doWriteSingle(channelOutboundBuffer, n2)) break;
        }
        this.setFlag(Native.EPOLLOUT);
    }

    protected boolean doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer, int n2) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            if (!this.writeBytes(channelOutboundBuffer, (ByteBuf)object, n2)) {
                return false;
            }
        } else if (object instanceof DefaultFileRegion) {
            if (!this.writeDefaultFileRegion(channelOutboundBuffer, (DefaultFileRegion)object, n2)) {
                return false;
            }
        } else if (object instanceof FileRegion) {
            if (!this.writeFileRegion(channelOutboundBuffer, (FileRegion)object, n2)) {
                return false;
            }
        } else if (object instanceof AbstractEpollStreamChannel$SpliceOutTask) {
            if (!((AbstractEpollStreamChannel$SpliceOutTask)object).spliceOut()) {
                return false;
            }
            channelOutboundBuffer.remove();
        } else {
            throw new Error();
        }
        return true;
    }

    private boolean doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer, int n2) {
        if (PlatformDependent.hasUnsafe()) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanArray();
            channelOutboundBuffer.forEachFlushedMessage(iovArray);
            int n3 = iovArray.count();
            if (n3 > 0) {
                if (!this.writeBytesMultiple(channelOutboundBuffer, iovArray, n2)) {
                    return false;
                }
            } else {
                channelOutboundBuffer.removeBytes(0L);
            }
        } else {
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers();
            int n4 = channelOutboundBuffer.nioBufferCount();
            if (n4 > 0) {
                if (!this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, n4, channelOutboundBuffer.nioBufferSize(), n2)) {
                    return false;
                }
            } else {
                channelOutboundBuffer.removeBytes(0L);
            }
        }
        return true;
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            if (!(((ByteBuf)(object = (ByteBuf)object)).hasMemoryAddress() || !PlatformDependent.hasUnsafe() && ((ByteBuf)object).isDirect())) {
                if (object instanceof CompositeByteBuf) {
                    CompositeByteBuf compositeByteBuf = (CompositeByteBuf)object;
                    if (!((ByteBuf)compositeByteBuf).isDirect() || ((ByteBuf)compositeByteBuf).nioBufferCount() > Native.IOV_MAX) {
                        object = this.newDirectBuffer((ByteBuf)object);
                        assert (((ByteBuf)object).hasMemoryAddress());
                    }
                } else {
                    object = this.newDirectBuffer((ByteBuf)object);
                    assert (((ByteBuf)object).hasMemoryAddress());
                }
            }
            return object;
        }
        if (object instanceof FileRegion || object instanceof AbstractEpollStreamChannel$SpliceOutTask) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.fd().shutdown(false, true);
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    @Override
    public boolean isInputShutdown() {
        return this.fd().isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.fd().isOutputShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        AbstractEpollStreamChannel abstractEpollStreamChannel = this;
        return abstractEpollStreamChannel.shutdownOutput(abstractEpollStreamChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        Executor executor = ((AbstractChannel$AbstractUnsafe)((AbstractEpollStreamChannel$EpollStreamUnsafe)this.unsafe())).prepareToClose();
        if (executor != null) {
            executor.execute(new AbstractEpollStreamChannel$2(this, channelPromise));
        } else {
            executor = this.eventLoop();
            if (executor.inEventLoop()) {
                this.shutdownOutput0(channelPromise);
            } else {
                executor.execute(new AbstractEpollStreamChannel$3(this, channelPromise));
            }
        }
        return channelPromise;
    }

    @Override
    public void doClose() {
        try {
            Future<Void> future = this.connectPromise;
            if (future != null) {
                future.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
                this.connectPromise = null;
            }
            if ((future = this.connectTimeoutFuture) != null) {
                future.cancel(false);
                this.connectTimeoutFuture = null;
            }
            super.doClose();
            return;
        }
        finally {
            AbstractEpollStreamChannel.safeClosePipe(this.pipeIn);
            AbstractEpollStreamChannel.safeClosePipe(this.pipeOut);
            this.clearSpliceQueue();
        }
    }

    private void clearSpliceQueue() {
        AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask;
        if (this.spliceQueue == null) {
            return;
        }
        while ((abstractEpollStreamChannel$SpliceInTask = this.spliceQueue.poll()) != null) {
            abstractEpollStreamChannel$SpliceInTask.promise.tryFailure(CLEAR_SPLICE_QUEUE_CLOSED_CHANNEL_EXCEPTION);
        }
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.fd().bind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = this.fd().connect(socketAddress);
            if (!bl2) {
                this.setFlag(Native.EPOLLOUT);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    private static void safeClosePipe(FileDescriptor fileDescriptor) {
        block3: {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                    return;
                }
                catch (IOException iOException) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Error while closing a pipe", iOException);
                }
            }
        }
    }

    private void addToSpliceQueue(AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.addToSpliceQueue0(abstractEpollStreamChannel$SpliceInTask);
            return;
        }
        eventLoop.execute(new AbstractEpollStreamChannel$4(this, abstractEpollStreamChannel$SpliceInTask));
    }

    private void addToSpliceQueue0(AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask) {
        if (this.spliceQueue == null) {
            this.spliceQueue = PlatformDependent.newMpscQueue();
        }
        this.spliceQueue.add(abstractEpollStreamChannel$SpliceInTask);
    }

    static /* synthetic */ void access$000(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        abstractEpollStreamChannel.clearSpliceQueue();
    }

    static /* synthetic */ ChannelPromise access$200(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$202(AbstractEpollStreamChannel abstractEpollStreamChannel, ChannelPromise channelPromise) {
        abstractEpollStreamChannel.connectPromise = channelPromise;
        return abstractEpollStreamChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$302(AbstractEpollStreamChannel abstractEpollStreamChannel, SocketAddress socketAddress) {
        abstractEpollStreamChannel.requestedRemoteAddress = socketAddress;
        return abstractEpollStreamChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$402(AbstractEpollStreamChannel abstractEpollStreamChannel, ScheduledFuture scheduledFuture) {
        abstractEpollStreamChannel.connectTimeoutFuture = scheduledFuture;
        return abstractEpollStreamChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$400(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$300(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.requestedRemoteAddress;
    }

    static /* synthetic */ Queue access$500(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.spliceQueue;
    }

    static /* synthetic */ void access$600(AbstractEpollStreamChannel abstractEpollStreamChannel, AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask) {
        abstractEpollStreamChannel.addToSpliceQueue0(abstractEpollStreamChannel$SpliceInTask);
    }

    static /* synthetic */ FileDescriptor access$700(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.pipeOut;
    }

    static /* synthetic */ FileDescriptor access$802(AbstractEpollStreamChannel abstractEpollStreamChannel, FileDescriptor fileDescriptor) {
        abstractEpollStreamChannel.pipeIn = fileDescriptor;
        return abstractEpollStreamChannel.pipeIn;
    }

    static /* synthetic */ FileDescriptor access$702(AbstractEpollStreamChannel abstractEpollStreamChannel, FileDescriptor fileDescriptor) {
        abstractEpollStreamChannel.pipeOut = fileDescriptor;
        return abstractEpollStreamChannel.pipeOut;
    }

    static /* synthetic */ FileDescriptor access$800(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.pipeIn;
    }

    static /* synthetic */ void access$900(FileDescriptor fileDescriptor) {
        AbstractEpollStreamChannel.safeClosePipe(fileDescriptor);
    }
}

