/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollMode;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import java.io.IOException;
import java.util.Map;

public class EpollChannelConfig
extends DefaultChannelConfig {
    final AbstractEpollChannel channel;

    EpollChannelConfig(AbstractEpollChannel abstractEpollChannel) {
        super(abstractEpollChannel);
        this.channel = abstractEpollChannel;
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        EpollChannelConfig epollChannelConfig = this;
        return epollChannelConfig.getOptions(super.getOptions(), EpollChannelOption.EPOLL_MODE);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == EpollChannelOption.EPOLL_MODE) {
            return (T)((Object)this.getEpollMode());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption != EpollChannelOption.EPOLL_MODE) {
            return super.setOption(channelOption, t2);
        }
        this.setEpollMode((EpollMode)((Object)t2));
        return true;
    }

    @Override
    public EpollChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    public EpollChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public EpollChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public EpollChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EpollChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public EpollChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public EpollChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public EpollChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public EpollChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    public EpollMode getEpollMode() {
        if (this.channel.isFlagSet(Native.EPOLLET)) {
            return EpollMode.EDGE_TRIGGERED;
        }
        return EpollMode.LEVEL_TRIGGERED;
    }

    public EpollChannelConfig setEpollMode(EpollMode epollMode) {
        if (epollMode == null) {
            throw new NullPointerException("mode");
        }
        try {
            switch (epollMode) {
                case EDGE_TRIGGERED: {
                    this.checkChannelNotRegistered();
                    this.channel.setFlag(Native.EPOLLET);
                    break;
                }
                case LEVEL_TRIGGERED: {
                    this.checkChannelNotRegistered();
                    this.channel.clearFlag(Native.EPOLLET);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    private void checkChannelNotRegistered() {
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("EpollMode can only be changed before channel is registered");
        }
    }

    @Override
    public final void autoReadCleared() {
        this.channel.clearEpollIn();
    }
}

