/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.AddressedEnvelope;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultAddressedEnvelope;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollDatagramChannel$EpollDatagramChannelUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollDatagramChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.IovArray;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.epoll.NativeDatagramPacketArray;
import com.aliyun.openservices.shade.io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramPacket;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile InetSocketAddress local;
    private volatile InetSocketAddress remote;
    private volatile boolean connected;
    private final EpollDatagramChannelConfig config;

    public EpollDatagramChannel() {
        super(Socket.newSocketDgram(), Native.EPOLLIN);
        this.config = new EpollDatagramChannelConfig(this);
    }

    @Deprecated
    public EpollDatagramChannel(FileDescriptor fileDescriptor) {
        this(new Socket(fileDescriptor.intValue()));
    }

    public EpollDatagramChannel(Socket socket) {
        super(null, socket, Native.EPOLLIN, true);
        this.local = socket.localAddress();
        this.config = new EpollDatagramChannelConfig(this);
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final boolean isActive() {
        return this.fd().isOpen() && (((DefaultChannelConfig)this.config).getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || this.active);
    }

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.joinGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (inetAddress2 == null) {
            throw new NullPointerException("sourceToBlock");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    protected final AbstractEpollChannel$AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannel$EpollDatagramChannelUnsafe(this);
    }

    @Override
    protected final InetSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected final InetSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    public final void doBind(SocketAddress socketAddress) {
        socketAddress = (InetSocketAddress)socketAddress;
        EpollDatagramChannel.checkResolvable((InetSocketAddress)socketAddress);
        this.fd().bind(socketAddress);
        this.local = this.fd().localAddress();
        this.active = true;
    }

    @Override
    public final void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        block2: while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            try {
                NativeDatagramPacketArray$NativeDatagramPacket[] nativeDatagramPacketArray$NativeDatagramPacketArray;
                int n2;
                if (Native.IS_SUPPORTING_SENDMMSG && channelOutboundBuffer.size() > 1 && (n2 = (nativeDatagramPacketArray$NativeDatagramPacketArray = NativeDatagramPacketArray.getInstance(channelOutboundBuffer)).count()) > 0) {
                    int n3 = 0;
                    nativeDatagramPacketArray$NativeDatagramPacketArray = nativeDatagramPacketArray$NativeDatagramPacketArray.packets();
                    while (true) {
                        if (n2 <= 0) continue block2;
                        int n4 = Native.sendmmsg(this.fd().intValue(), nativeDatagramPacketArray$NativeDatagramPacketArray, n3, n2);
                        if (n4 == 0) {
                            this.setFlag(Native.EPOLLOUT);
                            return;
                        }
                        for (int i2 = 0; i2 < n4; ++i2) {
                            channelOutboundBuffer.remove();
                        }
                        n2 -= n4;
                        n3 += n4;
                    }
                }
                boolean bl = false;
                for (n2 = this.config().getWriteSpinCount() - 1; n2 >= 0; --n2) {
                    if (!this.doWriteMessage(object)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                this.setFlag(Native.EPOLLOUT);
                return;
            }
            catch (IOException iOException) {
                channelOutboundBuffer.remove(iOException);
                continue;
            }
            break;
        }
    }

    private boolean doWriteMessage(Object object) {
        InetSocketAddress inetSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            object = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)object.content();
            inetSocketAddress = (InetSocketAddress)object.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            inetSocketAddress = null;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        if (inetSocketAddress == null && (inetSocketAddress = this.remote) == null) {
            throw new NotYetConnectedException();
        }
        if (byteBuf.hasMemoryAddress()) {
            long l2 = byteBuf.memoryAddress();
            n2 = this.fd().sendToAddress(l2, byteBuf.readerIndex(), byteBuf.writerIndex(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else if (byteBuf instanceof CompositeByteBuf) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanArray();
            iovArray.add(byteBuf);
            int n3 = iovArray.count();
            assert (n3 != 0);
            n2 = this.fd().sendToAddresses(iovArray.memoryAddress(0), n3, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else {
            ByteBuffer byteBuffer;
            ByteBuf byteBuf2 = byteBuf;
            ByteBuffer byteBuffer2 = byteBuffer = byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), byteBuf.readableBytes());
            n2 = this.fd().sendTo(byteBuffer2, byteBuffer2.position(), byteBuffer.limit(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        return n2 > 0;
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DatagramPacket) {
            CompositeByteBuf compositeByteBuf;
            DatagramPacket datagramPacket = (DatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            if (byteBuf.hasMemoryAddress()) {
                return object;
            }
            if (byteBuf.isDirect() && byteBuf instanceof CompositeByteBuf && ((ByteBuf)(compositeByteBuf = (CompositeByteBuf)byteBuf)).isDirect() && ((ByteBuf)compositeByteBuf).nioBufferCount() <= Native.IOV_MAX) {
                return object;
            }
            return new DatagramPacket(this.newDirectBuffer(datagramPacket, byteBuf), (InetSocketAddress)datagramPacket.recipient());
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!(byteBuf.hasMemoryAddress() || !PlatformDependent.hasUnsafe() && byteBuf.isDirect())) {
                if (byteBuf instanceof CompositeByteBuf) {
                    CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                    if (!((ByteBuf)compositeByteBuf).isDirect() || ((ByteBuf)compositeByteBuf).nioBufferCount() > Native.IOV_MAX) {
                        byteBuf = this.newDirectBuffer(byteBuf);
                        assert (byteBuf.hasMemoryAddress());
                    }
                } else {
                    byteBuf = this.newDirectBuffer(byteBuf);
                    assert (byteBuf.hasMemoryAddress());
                }
            }
            return byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof InetSocketAddress)) {
            CompositeByteBuf compositeByteBuf;
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            if (byteBuf.hasMemoryAddress()) {
                return addressedEnvelope;
            }
            if (byteBuf instanceof CompositeByteBuf && ((ByteBuf)(compositeByteBuf = (CompositeByteBuf)byteBuf)).isDirect() && ((ByteBuf)compositeByteBuf).nioBufferCount() <= Native.IOV_MAX) {
                return addressedEnvelope;
            }
            return new DefaultAddressedEnvelope<ByteBuf, InetSocketAddress>(this.newDirectBuffer(addressedEnvelope, byteBuf), (InetSocketAddress)addressedEnvelope.recipient());
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    @Override
    public final EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    public final void doDisconnect() {
        this.connected = false;
    }

    static /* synthetic */ InetSocketAddress access$002(EpollDatagramChannel epollDatagramChannel, InetSocketAddress inetSocketAddress) {
        epollDatagramChannel.remote = inetSocketAddress;
        return epollDatagramChannel.remote;
    }

    static /* synthetic */ InetSocketAddress access$102(EpollDatagramChannel epollDatagramChannel, InetSocketAddress inetSocketAddress) {
        epollDatagramChannel.local = inetSocketAddress;
        return epollDatagramChannel.local;
    }

    static /* synthetic */ boolean access$202(EpollDatagramChannel epollDatagramChannel, boolean bl) {
        epollDatagramChannel.connected = bl;
        return epollDatagramChannel.connected;
    }
}

