/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;

final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private long memoryAddress;
    private int length;

    EpollEventArray(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("length must be >= 1 but was " + n2);
        }
        this.length = n2;
        this.memoryAddress = EpollEventArray.allocate(n2);
    }

    private static long allocate(int n2) {
        return PlatformDependent.allocateMemory(n2 * EPOLL_EVENT_SIZE);
    }

    final long memoryAddress() {
        return this.memoryAddress;
    }

    final int length() {
        return this.length;
    }

    final void increase() {
        this.length <<= 1;
        this.free();
        this.memoryAddress = EpollEventArray.allocate(this.length);
    }

    final void free() {
        PlatformDependent.freeMemory(this.memoryAddress);
    }

    final int events(int n2) {
        return PlatformDependent.getInt(this.memoryAddress + (long)(n2 * EPOLL_EVENT_SIZE));
    }

    final int fd(int n2) {
        return PlatformDependent.getInt(this.memoryAddress + (long)(n2 * EPOLL_EVENT_SIZE) + (long)EPOLL_DATA_OFFSET);
    }
}

