/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.SelectStrategy;
import com.aliyun.openservices.shade.io.netty.channel.SingleThreadEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventArray;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop$1;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop$2;
import com.aliyun.openservices.shade.io.netty.channel.epoll.IovArray;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.util.IntSupplier;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectHashMap;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectMap;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectMap$Entry;
import com.aliyun.openservices.shade.io.netty.util.concurrent.RejectedExecutionHandler;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final AtomicIntegerFieldUpdater<EpollEventLoop> WAKEN_UP_UPDATER;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private final IovArray iovArray = new IovArray();
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new EpollEventLoop$1(this);
    private final Callable<Integer> pendingTasksCallable = new EpollEventLoop$2(this);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    EpollEventLoop(EventLoopGroup object, ThreadFactory object2, int n2, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventLoopGroup)object, (ThreadFactory)object2, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "strategy");
        if (n2 == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(n2);
        }
        object = null;
        object2 = null;
        try {
            object = Native.newEpollCreate();
            this.epollFd = object;
            object2 = Native.newEventFd();
            this.eventFd = object2;
            try {
                Native.epollCtlAdd(((FileDescriptor)object).intValue(), ((FileDescriptor)object2).intValue(), Native.EPOLLIN);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", iOException);
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    ((FileDescriptor)object).close();
                }
                catch (Exception exception) {}
            }
            if (object2 != null) {
                try {
                    ((FileDescriptor)object2).close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
    }

    final IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    public final void wakeup(boolean bl) {
        if (!bl && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    final void add(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n2 = abstractEpollChannel.fd().intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), n2, abstractEpollChannel.flags);
        this.channels.put(n2, abstractEpollChannel);
    }

    final void modify(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), abstractEpollChannel.fd().intValue(), abstractEpollChannel.flags);
    }

    final void remove(AbstractEpollChannel abstractEpollChannel) {
        int n2;
        assert (this.inEventLoop());
        if (abstractEpollChannel.isOpen() && this.channels.remove(n2 = abstractEpollChannel.fd().intValue()) != null) {
            Native.epollCtlDel(this.epollFd.intValue(), abstractEpollChannel.fd().intValue());
        }
    }

    @Override
    public final Queue<Runnable> newTaskQueue(int n2) {
        return PlatformDependent.newMpscQueue(n2);
    }

    @Override
    public final int pendingTasks() {
        if (this.inEventLoop()) {
            return super.pendingTasks();
        }
        EpollEventLoop epollEventLoop = this;
        return (Integer)epollEventLoop.submit(epollEventLoop.pendingTasksCallable).syncUninterruptibly().getNow();
    }

    public final int getIoRatio() {
        return this.ioRatio;
    }

    public final void setIoRatio(int n2) {
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n2 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n2;
    }

    private int epollWait(boolean bl) {
        int n2 = 0;
        long l2 = System.nanoTime();
        long l3 = l2 + this.delayNanos(l2);
        while (true) {
            long l4;
            if ((l4 = (l3 - l2 + 500000L) / 1000000L) <= 0L) {
                int n3;
                if (n2 != 0 || (n3 = Native.epollWait(this.epollFd.intValue(), this.events, 0)) <= 0) break;
                return n3;
            }
            if (this.hasTasks() && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
                return Native.epollWait(this.epollFd.intValue(), this.events, 0);
            }
            int n4 = Native.epollWait(this.epollFd.intValue(), this.events, (int)l4);
            ++n2;
            if (n4 != 0 || bl || this.wakenUp == 1 || this.hasTasks() || this.hasScheduledTasks()) {
                return n4;
            }
            l2 = System.nanoTime();
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        while (true) {
            try {
                block15: while (true) {
                    var1_1 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (var1_1) {
                        case -2: {
                            continue block15;
                        }
                        case -1: {
                            var1_1 = this.epollWait(EpollEventLoop.WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                            if (this.wakenUp != 1) break block15;
                            Native.eventFdWrite(this.eventFd.intValue(), 1L);
                        }
                    }
                    break;
                }
                var2_5 = this.ioRatio;
                if (var2_5 == 100) {
                    try {
                        if (var1_1 <= 0) ** GOTO lbl34
                        v0 = this;
                        v0.processReady(v0.events, var1_1);
                    }
                    finally {
                        this.runAllTasks();
                    }
                } else {
                    var4_6 = System.nanoTime();
                    try {
                        if (var1_1 > 0) {
                            v1 = this;
                            v1.processReady(v1.events, var1_1);
                        }
                    }
                    finally {
                        var6_7 = System.nanoTime() - var4_6;
                        this.runAllTasks(var6_7 * (long)(100 - var2_5) / (long)var2_5);
                    }
                }
                if (this.allowGrowing && var1_1 == this.events.length()) {
                    this.events.increase();
                }
            }
            catch (Throwable v2) {
                var1_4 = v2;
                EpollEventLoop.handleLoopException(v2);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
                return;
            }
            catch (Throwable v3) {
                var1_4 = v3;
                EpollEventLoop.handleLoopException(v3);
                continue;
            }
            break;
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void closeAll() {
        try {
            Native.epollWait(this.epollFd.intValue(), this.events, 0);
        }
        catch (IOException iOException) {}
        ArrayList<AbstractEpollChannel> arrayList = new ArrayList<AbstractEpollChannel>(this.channels.size());
        for (IntObjectMap$Entry<AbstractEpollChannel> object : this.channels.entries()) {
            arrayList.add(object.value());
        }
        for (AbstractEpollChannel abstractEpollChannel : arrayList) {
            abstractEpollChannel.unsafe().close(abstractEpollChannel.unsafe().voidPromise());
        }
    }

    private void processReady(EpollEventArray epollEventArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = epollEventArray.fd(i2);
            if (n3 == this.eventFd.intValue()) {
                Native.eventFdRead(this.eventFd.intValue());
                continue;
            }
            long l2 = epollEventArray.events(i2);
            AbstractEpollChannel abstractEpollChannel = this.channels.get(n3);
            if (abstractEpollChannel != null) {
                AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)abstractEpollChannel.unsafe();
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollOutReady();
                }
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollInReady();
                }
                if ((l2 & (long)Native.EPOLLRDHUP) == 0L) continue;
                abstractEpollChannel$AbstractEpollUnsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), n3);
                continue;
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public final void cleanup() {
        try {
            try {
                this.epollFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the epoll fd.", iOException);
            }
            try {
                this.eventFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the event fd.", iOException);
            }
            return;
        }
        finally {
            this.iovArray.release();
            this.events.free();
        }
    }

    static /* synthetic */ FileDescriptor access$000(EpollEventLoop epollEventLoop) {
        return epollEventLoop.epollFd;
    }

    static /* synthetic */ EpollEventArray access$100(EpollEventLoop epollEventLoop) {
        return epollEventLoop.events;
    }

    static /* synthetic */ int access$201(EpollEventLoop epollEventLoop) {
        return super.pendingTasks();
    }

    static {
        AtomicIntegerFieldUpdater<EpollEventLoop> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(EpollEventLoop.class, "wakenUp");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(EpollEventLoop.class, "wakenUp");
        }
        WAKEN_UP_UPDATER = atomicIntegerFieldUpdater;
    }
}

