/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollDomainSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.unix.DomainSocketAddress;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.ServerDomainSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;

public final class EpollServerDomainSocketChannel
extends AbstractEpollServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollServerDomainSocketChannel.class);
    private final EpollServerChannelConfig config = new EpollServerChannelConfig(this);
    private volatile DomainSocketAddress local;

    public EpollServerDomainSocketChannel() {
        super(Socket.newSocketDomain(), false);
    }

    public EpollServerDomainSocketChannel(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public EpollServerDomainSocketChannel(Socket socket) {
        super(socket);
    }

    public EpollServerDomainSocketChannel(Socket socket, boolean bl) {
        super(socket, bl);
    }

    @Override
    protected final Channel newChildChannel(int n2, byte[] byArray, int n3, int n4) {
        return new EpollDomainSocketChannel((Channel)this, new Socket(n2));
    }

    @Override
    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public final void doBind(SocketAddress socketAddress) {
        this.fd().bind(socketAddress);
        this.fd().listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)socketAddress;
    }

    @Override
    public final void doClose() {
        try {
            super.doClose();
            return;
        }
        finally {
            File file;
            boolean bl;
            DomainSocketAddress domainSocketAddress = this.local;
            if (domainSocketAddress != null && !(bl = (file = new File(domainSocketAddress.path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)domainSocketAddress.path());
            }
        }
    }

    @Override
    public final EpollServerChannelConfig config() {
        return this.config;
    }

    @Override
    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }
}

