/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.epoll.TcpMd5Util;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.NativeInetAddress;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile InetSocketAddress local;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel() {
        super(Socket.newSocketStream(), false);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Deprecated
    public EpollServerSocketChannel(FileDescriptor fileDescriptor) {
        this(new Socket(fileDescriptor.intValue()));
    }

    @Deprecated
    public EpollServerSocketChannel(Socket socket) {
        super(socket);
        this.local = socket.localAddress();
        this.config = new EpollServerSocketChannelConfig(this);
    }

    public EpollServerSocketChannel(Socket socket, boolean bl) {
        super(socket, bl);
        this.local = socket.localAddress();
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    public final boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    public final void doBind(SocketAddress socketAddress) {
        socketAddress = (InetSocketAddress)socketAddress;
        EpollServerSocketChannel.checkResolvable((InetSocketAddress)socketAddress);
        this.fd().bind(socketAddress);
        this.local = this.fd().localAddress();
        if (Native.IS_SUPPORTING_TCP_FASTOPEN && this.config.getTcpFastopen() > 0) {
            Native.setTcpFastopen(this.fd().intValue(), this.config.getTcpFastopen());
        }
        this.fd().listen(this.config.getBacklog());
        this.active = true;
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected final InetSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected final Channel newChildChannel(int n2, byte[] byArray, int n3, int n4) {
        return new EpollSocketChannel(this, new Socket(n2), NativeInetAddress.address(byArray, n3, n4));
    }

    final Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    final void setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, map);
    }
}

