/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannelConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public final class EpollServerSocketChannelConfig
extends EpollServerChannelConfig
implements ServerSocketChannelConfig {
    EpollServerSocketChannelConfig(EpollServerSocketChannel epollServerSocketChannel) {
        super(epollServerSocketChannel);
        this.setReuseAddress(true);
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        EpollServerSocketChannelConfig epollServerSocketChannelConfig = this;
        return epollServerSocketChannelConfig.getOptions(super.getOptions(), EpollChannelOption.SO_REUSEPORT, EpollChannelOption.IP_FREEBIND, EpollChannelOption.TCP_DEFER_ACCEPT);
    }

    @Override
    public final <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == EpollChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (channelOption == EpollChannelOption.IP_FREEBIND) {
            return (T)Boolean.valueOf(this.isFreeBind());
        }
        if (channelOption == EpollChannelOption.TCP_DEFER_ACCEPT) {
            return (T)Integer.valueOf(this.getTcpDeferAccept());
        }
        return super.getOption(channelOption);
    }

    @Override
    public final <T> boolean setOption(ChannelOption<T> object, T t2) {
        this.validate(object, t2);
        if (object == EpollChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)t2);
        } else if (object == EpollChannelOption.IP_FREEBIND) {
            this.setFreeBind((Boolean)t2);
        } else if (object == EpollChannelOption.TCP_MD5SIG) {
            object = (Map)t2;
            this.setTcpMd5Sig((Map<InetAddress, byte[]>)object);
        } else if (object == EpollChannelOption.TCP_DEFER_ACCEPT) {
            this.setTcpDeferAccept((Integer)t2);
        } else {
            return super.setOption(object, t2);
        }
        return true;
    }

    @Override
    public final EpollServerSocketChannelConfig setReuseAddress(boolean bl) {
        super.setReuseAddress(bl);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setReceiveBufferSize(int n2) {
        super.setReceiveBufferSize(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setPerformancePreferences(int n2, int n3, int n4) {
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setBacklog(int n2) {
        super.setBacklog(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public final EpollServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    public final EpollServerSocketChannelConfig setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        try {
            ((EpollServerSocketChannel)this.channel).setTcpMd5Sig(map);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final boolean isReusePort() {
        try {
            return Native.isReusePort(this.channel.fd().intValue()) == 1;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollServerSocketChannelConfig setReusePort(boolean bl) {
        try {
            Native.setReusePort(this.channel.fd().intValue(), bl ? 1 : 0);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final boolean isFreeBind() {
        try {
            return Native.isIpFreeBind(this.channel.fd().intValue()) != 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollServerSocketChannelConfig setFreeBind(boolean bl) {
        try {
            Native.setIpFreeBind(this.channel.fd().intValue(), bl ? 1 : 0);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollServerSocketChannelConfig setTcpDeferAccept(int n2) {
        try {
            this.channel.fd().setTcpDeferAccept(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final int getTcpDeferAccept() {
        try {
            return this.channel.fd().getTcpDeferAccept();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }
}

