/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.AbstractEpollStreamChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollSocketChannel$EpollSocketChannelUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollTcpInfo;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.epoll.TcpMd5Util;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.Socket;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyConnectedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class EpollSocketChannel
extends AbstractEpollStreamChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config;
    private volatile InetSocketAddress local;
    private volatile InetSocketAddress remote;
    private InetSocketAddress requestedRemote;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    EpollSocketChannel(Channel channel, Socket socket, InetSocketAddress inetSocketAddress) {
        super(channel, socket);
        this.config = new EpollSocketChannelConfig(this);
        this.remote = inetSocketAddress;
        this.local = socket.localAddress();
        if (channel instanceof EpollServerSocketChannel) {
            this.tcpMd5SigAddresses = ((EpollServerSocketChannel)channel).tcpMd5SigAddresses();
        }
    }

    public EpollSocketChannel() {
        super(Socket.newSocketStream(), false);
        this.config = new EpollSocketChannelConfig(this);
    }

    @Deprecated
    public EpollSocketChannel(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
        this.remote = this.fd().remoteAddress();
        this.local = this.fd().localAddress();
        this.config = new EpollSocketChannelConfig(this);
    }

    public EpollSocketChannel(Socket socket, boolean bl) {
        super(socket, bl);
        this.remote = socket.remoteAddress();
        this.local = socket.localAddress();
        this.config = new EpollSocketChannelConfig(this);
    }

    public final EpollTcpInfo tcpInfo() {
        return this.tcpInfo(new EpollTcpInfo());
    }

    public final EpollTcpInfo tcpInfo(EpollTcpInfo epollTcpInfo) {
        try {
            Native.tcpInfo(this.fd().intValue(), epollTcpInfo);
            return epollTcpInfo;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public final SocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    public final void doBind(SocketAddress socketAddress) {
        socketAddress = (InetSocketAddress)socketAddress;
        this.fd().bind(socketAddress);
        this.local = this.fd().localAddress();
    }

    @Override
    public final EpollSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public final ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected final AbstractEpollChannel$AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketChannel$EpollSocketChannelUnsafe(this, null);
    }

    private static InetSocketAddress computeRemoteAddr(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        if (inetSocketAddress2 != null) {
            if (PlatformDependent.javaVersion() >= 7) {
                try {
                    return new InetSocketAddress(InetAddress.getByAddress(inetSocketAddress.getHostString(), inetSocketAddress2.getAddress().getAddress()), inetSocketAddress2.getPort());
                }
                catch (UnknownHostException unknownHostException) {}
            }
            return inetSocketAddress2;
        }
        return inetSocketAddress;
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            EpollSocketChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        EpollSocketChannel.checkResolvable(inetSocketAddress);
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        boolean bl = super.doConnect(socketAddress, socketAddress2);
        if (bl) {
            this.remote = EpollSocketChannel.computeRemoteAddr(inetSocketAddress, this.fd().remoteAddress());
        } else {
            this.requestedRemote = inetSocketAddress;
        }
        this.local = this.fd().localAddress();
        return bl;
    }

    final void setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, map);
    }

    static /* synthetic */ InetSocketAddress access$102(EpollSocketChannel epollSocketChannel, InetSocketAddress inetSocketAddress) {
        epollSocketChannel.remote = inetSocketAddress;
        return epollSocketChannel.remote;
    }

    static /* synthetic */ InetSocketAddress access$200(EpollSocketChannel epollSocketChannel) {
        return epollSocketChannel.requestedRemote;
    }

    static /* synthetic */ InetSocketAddress access$300(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        return EpollSocketChannel.computeRemoteAddr(inetSocketAddress, inetSocketAddress2);
    }

    static /* synthetic */ InetSocketAddress access$202(EpollSocketChannel epollSocketChannel, InetSocketAddress inetSocketAddress) {
        epollSocketChannel.requestedRemote = inetSocketAddress;
        return epollSocketChannel.requestedRemote;
    }
}

