/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollMode;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public final class EpollSocketChannelConfig
extends EpollChannelConfig
implements SocketChannelConfig {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;
    private final EpollSocketChannel channel;
    private volatile boolean allowHalfClosure;

    EpollSocketChannelConfig(EpollSocketChannel epollSocketChannel) {
        super(epollSocketChannel);
        this.channel = epollSocketChannel;
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
        this.setMaxMessagesPerRead(16);
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        EpollSocketChannelConfig epollSocketChannelConfig = this;
        return epollSocketChannelConfig.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, EpollChannelOption.TCP_CORK, EpollChannelOption.TCP_NOTSENT_LOWAT, EpollChannelOption.TCP_KEEPCNT, EpollChannelOption.TCP_KEEPIDLE, EpollChannelOption.TCP_KEEPINTVL, EpollChannelOption.TCP_MD5SIG, EpollChannelOption.TCP_QUICKACK);
    }

    @Override
    public final <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (channelOption == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (channelOption == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (channelOption == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (channelOption == EpollChannelOption.TCP_CORK) {
            return (T)Boolean.valueOf(this.isTcpCork());
        }
        if (channelOption == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            return (T)Long.valueOf(this.getTcpNotSentLowAt());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPIDLE) {
            return (T)Integer.valueOf(this.getTcpKeepIdle());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPINTVL) {
            return (T)Integer.valueOf(this.getTcpKeepIntvl());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPCNT) {
            return (T)Integer.valueOf(this.getTcpKeepCnt());
        }
        if (channelOption == EpollChannelOption.TCP_USER_TIMEOUT) {
            return (T)Integer.valueOf(this.getTcpUserTimeout());
        }
        if (channelOption == EpollChannelOption.TCP_QUICKACK) {
            return (T)Boolean.valueOf(this.isTcpQuickAck());
        }
        return super.getOption(channelOption);
    }

    @Override
    public final <T> boolean setOption(ChannelOption<T> object, T t2) {
        this.validate(object, t2);
        if (object == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t2);
        } else if (object == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t2);
        } else if (object == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)t2);
        } else if (object == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)t2);
        } else if (object == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t2);
        } else if (object == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)t2);
        } else if (object == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)t2);
        } else if (object == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)t2);
        } else if (object == EpollChannelOption.TCP_CORK) {
            this.setTcpCork((Boolean)t2);
        } else if (object == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            this.setTcpNotSentLowAt((Long)t2);
        } else if (object == EpollChannelOption.TCP_KEEPIDLE) {
            this.setTcpKeepIdle((Integer)t2);
        } else if (object == EpollChannelOption.TCP_KEEPCNT) {
            this.setTcpKeepCntl((Integer)t2);
        } else if (object == EpollChannelOption.TCP_KEEPINTVL) {
            this.setTcpKeepIntvl((Integer)t2);
        } else if (object == EpollChannelOption.TCP_USER_TIMEOUT) {
            this.setTcpUserTimeout((Integer)t2);
        } else if (object == EpollChannelOption.TCP_MD5SIG) {
            object = (Map)t2;
            this.setTcpMd5Sig((Map<InetAddress, byte[]>)object);
        } else if (object == EpollChannelOption.TCP_QUICKACK) {
            this.setTcpQuickAck((Boolean)t2);
        } else {
            return super.setOption(object, t2);
        }
        return true;
    }

    @Override
    public final int getReceiveBufferSize() {
        try {
            return this.channel.fd().getReceiveBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final int getSendBufferSize() {
        try {
            return this.channel.fd().getSendBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final int getSoLinger() {
        try {
            return this.channel.fd().getSoLinger();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final int getTrafficClass() {
        try {
            return Native.getTrafficClass(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final boolean isKeepAlive() {
        try {
            return this.channel.fd().isKeepAlive();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final boolean isReuseAddress() {
        try {
            return Native.isReuseAddress(this.channel.fd().intValue()) == 1;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final boolean isTcpNoDelay() {
        try {
            return this.channel.fd().isTcpNoDelay();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final boolean isTcpCork() {
        try {
            return this.channel.fd().isTcpCork();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final long getTcpNotSentLowAt() {
        try {
            return (long)Native.getTcpNotSentLowAt(this.channel.fd().intValue()) & 0xFFFFFFFFL;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final int getTcpKeepIdle() {
        try {
            return Native.getTcpKeepIdle(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final int getTcpKeepIntvl() {
        try {
            return Native.getTcpKeepIntvl(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final int getTcpKeepCnt() {
        try {
            return Native.getTcpKeepCnt(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final int getTcpUserTimeout() {
        try {
            return Native.getTcpUserTimeout(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setKeepAlive(boolean bl) {
        try {
            this.channel.fd().setKeepAlive(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setPerformancePreferences(int n2, int n3, int n4) {
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setReceiveBufferSize(int n2) {
        try {
            this.channel.fd().setReceiveBufferSize(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setReuseAddress(boolean bl) {
        try {
            Native.setReuseAddress(this.channel.fd().intValue(), bl ? 1 : 0);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setSendBufferSize(int n2) {
        try {
            this.channel.fd().setSendBufferSize(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setSoLinger(int n2) {
        try {
            this.channel.fd().setSoLinger(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setTcpNoDelay(boolean bl) {
        try {
            this.channel.fd().setTcpNoDelay(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpCork(boolean bl) {
        try {
            this.channel.fd().setTcpCork(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpNotSentLowAt(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        try {
            Native.setTcpNotSentLowAt(this.channel.fd().intValue(), (int)l2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final EpollSocketChannelConfig setTrafficClass(int n2) {
        try {
            Native.setTrafficClass(this.channel.fd().intValue(), n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpKeepIdle(int n2) {
        try {
            Native.setTcpKeepIdle(this.channel.fd().intValue(), n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpKeepIntvl(int n2) {
        try {
            Native.setTcpKeepIntvl(this.channel.fd().intValue(), n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpKeepCntl(int n2) {
        try {
            Native.setTcpKeepCnt(this.channel.fd().intValue(), n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpUserTimeout(int n2) {
        try {
            Native.setTcpUserTimeout(this.channel.fd().intValue(), n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        try {
            this.channel.setTcpMd5Sig(map);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final EpollSocketChannelConfig setTcpQuickAck(boolean bl) {
        try {
            this.channel.fd().setTcpQuickAck(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public final boolean isTcpQuickAck() {
        try {
            return this.channel.fd().isTcpQuickAck();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public final EpollSocketChannelConfig setAllowHalfClosure(boolean bl) {
        this.allowHalfClosure = bl;
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setAutoClose(boolean bl) {
        super.setAutoClose(bl);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    public final EpollSocketChannelConfig setEpollMode(EpollMode epollMode) {
        super.setEpollMode(epollMode);
        return this;
    }
}

