/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.epoll;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Native;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class IovArray
implements ChannelOutboundBuffer$MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Native.IOV_MAX * IOV_SIZE;
    private final long memoryAddress = PlatformDependent.allocateMemory(CAPACITY);
    private int count;
    private long size;

    IovArray() {
    }

    final void clear() {
        this.count = 0;
        this.size = 0L;
    }

    final boolean add(ByteBuf byteBuf) {
        if (this.count == Native.IOV_MAX) {
            return false;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        long l2 = byteBuf.memoryAddress();
        int n3 = byteBuf.readerIndex();
        return this.add(l2, n3, n2);
    }

    private boolean add(long l2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        IovArray iovArray = this;
        long l3 = iovArray.memoryAddress(iovArray.count++);
        long l4 = l3 + (long)ADDRESS_SIZE;
        if (Native.SSIZE_MAX - (long)n3 < this.size) {
            return false;
        }
        this.size += (long)n3;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong(l3, l2 + (long)n2);
            PlatformDependent.putLong(l4, n3);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt(l3, (int)l2 + n2);
            PlatformDependent.putInt(l4, n3);
        }
        return true;
    }

    final boolean add(CompositeByteBuf byteBufferArray) {
        if (this.count + (byteBufferArray = byteBufferArray.nioBuffers()).length >= Native.IOV_MAX) {
            return false;
        }
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            long l2;
            ByteBuffer byteBuffer = byteBufferArray[i2];
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit() - byteBuffer.position();
            if (n3 == 0 || this.add(l2 = PlatformDependent.directBufferAddress(byteBuffer), n2, n3)) continue;
            return false;
        }
        return true;
    }

    final long processWritten(int n2, long l2) {
        long l3 = this.memoryAddress(n2);
        long l4 = l3 + (long)ADDRESS_SIZE;
        if (ADDRESS_SIZE == 8) {
            long l5 = PlatformDependent.getLong(l4);
            if (l5 > l2) {
                long l6 = PlatformDependent.getLong(l3);
                PlatformDependent.putLong(l3, l6 + l2);
                PlatformDependent.putLong(l4, l5 - l2);
                return -1L;
            }
            return l5;
        }
        assert (ADDRESS_SIZE == 4);
        long l7 = PlatformDependent.getInt(l4);
        if (l7 > l2) {
            n2 = PlatformDependent.getInt(l3);
            PlatformDependent.putInt(l3, (int)((long)n2 + l2));
            PlatformDependent.putInt(l4, (int)(l7 - l2));
            return -1L;
        }
        return l7;
    }

    final int count() {
        return this.count;
    }

    final long size() {
        return this.size;
    }

    final long memoryAddress(int n2) {
        return this.memoryAddress + (long)(IOV_SIZE * n2);
    }

    final void release() {
        PlatformDependent.freeMemory(this.memoryAddress);
    }

    @Override
    public final boolean processMessage(Object object) {
        if (object instanceof ByteBuf) {
            if (object instanceof CompositeByteBuf) {
                return this.add((CompositeByteBuf)object);
            }
            return this.add((ByteBuf)object);
        }
        return false;
    }
}

