/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.group;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufHolder;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.group.ChannelGroup;
import com.aliyun.openservices.shade.io.netty.channel.group.ChannelGroupFuture;
import com.aliyun.openservices.shade.io.netty.channel.group.ChannelMatcher;
import com.aliyun.openservices.shade.io.netty.channel.group.ChannelMatchers;
import com.aliyun.openservices.shade.io.netty.channel.group.CombinedIterator;
import com.aliyun.openservices.shade.io.netty.channel.group.DefaultChannelGroup$1;
import com.aliyun.openservices.shade.io.netty.channel.group.DefaultChannelGroupFuture;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.ConcurrentSet;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final EventExecutor executor;
    private final ConcurrentSet<Channel> serverChannels = new ConcurrentSet();
    private final ConcurrentSet<Channel> nonServerChannels = new ConcurrentSet();
    private final ChannelFutureListener remover = new DefaultChannelGroup$1(this);
    private final boolean stayClosed;
    private volatile boolean closed;

    public DefaultChannelGroup(EventExecutor eventExecutor) {
        this(eventExecutor, false);
    }

    public DefaultChannelGroup(String string, EventExecutor eventExecutor) {
        this(string, eventExecutor, false);
    }

    public DefaultChannelGroup(EventExecutor eventExecutor, boolean bl) {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()), eventExecutor, bl);
    }

    public DefaultChannelGroup(String string, EventExecutor eventExecutor, boolean bl) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.name = string;
        this.executor = eventExecutor;
        this.stayClosed = bl;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Channel) {
            Channel channel = (Channel)object;
            if (object instanceof ServerChannel) {
                return this.serverChannels.contains(channel);
            }
            return this.nonServerChannels.contains(channel);
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        ConcurrentSet<Channel> concurrentSet = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl = concurrentSet.add(channel);
        if (bl) {
            channel.closeFuture().addListener(this.remover);
        }
        if (this.stayClosed && this.closed) {
            channel.close();
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Channel)) {
            return false;
        }
        boolean bl = (object = (Channel)object) instanceof ServerChannel ? this.serverChannels.remove(object) : this.nonServerChannels.remove(object);
        if (!bl) {
            return false;
        }
        object.closeFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.iterator(), this.nonServerChannels.iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList<Channel> arrayList = new ArrayList<Channel>(this.size());
        arrayList.addAll(this.serverChannels);
        arrayList.addAll(this.nonServerChannels);
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList<Channel> arrayList = new ArrayList<Channel>(this.size());
        arrayList.addAll(this.serverChannels);
        arrayList.addAll(this.nonServerChannels);
        return arrayList.toArray(TArray);
    }

    @Override
    public ChannelGroupFuture close() {
        return this.close(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture disconnect() {
        return this.disconnect(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture deregister() {
        return this.deregister(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture write(Object object) {
        return this.write(object, ChannelMatchers.all());
    }

    private static Object safeDuplicate(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).duplicate().retain();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).duplicate().retain();
        }
        return ReferenceCountUtil.retain(object);
    }

    @Override
    public ChannelGroupFuture write(Object object, ChannelMatcher channelMatcher) {
        if (object == null) {
            throw new NullPointerException("message");
        }
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.write(DefaultChannelGroup.safeDuplicate(object)));
        }
        ReferenceCountUtil.release(object);
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroup flush() {
        return this.flush(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture flushAndWrite(Object object) {
        return this.writeAndFlush(object);
    }

    @Override
    public ChannelGroupFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture disconnect(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.disconnect());
        }
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel3 = channel;
            linkedHashMap.put(channel3, channel3.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroupFuture close(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        if (this.stayClosed) {
            this.closed = true;
        }
        for (Channel channel : this.serverChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.close());
        }
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel3 = channel;
            linkedHashMap.put(channel3, channel3.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroupFuture deregister(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.deregister());
        }
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel3 = channel;
            linkedHashMap.put(channel3, channel3.deregister());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroup flush(ChannelMatcher channelMatcher) {
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            channel.flush();
        }
        return this;
    }

    @Override
    public ChannelGroupFuture flushAndWrite(Object object, ChannelMatcher channelMatcher) {
        return this.writeAndFlush(object, channelMatcher);
    }

    @Override
    public ChannelGroupFuture writeAndFlush(Object object, ChannelMatcher channelMatcher) {
        if (object == null) {
            throw new NullPointerException("message");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.writeAndFlush(DefaultChannelGroup.safeDuplicate(object)));
        }
        ReferenceCountUtil.release(object);
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    public ChannelGroupFuture newCloseFuture() {
        return this.newCloseFuture(ChannelMatchers.all());
    }

    public ChannelGroupFuture newCloseFuture(ChannelMatcher channelMatcher) {
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel2 = channel;
            linkedHashMap.put(channel2, channel2.closeFuture());
        }
        for (Channel channel : this.nonServerChannels) {
            if (!channelMatcher.matches(channel)) continue;
            Channel channel3 = channel;
            linkedHashMap.put(channel3, channel3.closeFuture());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(ChannelGroup channelGroup) {
        int n2 = this.name().compareTo(channelGroup.name());
        if (n2 != 0) {
            return n2;
        }
        return System.identityHashCode(this) - System.identityHashCode(channelGroup);
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(name: " + this.name() + ", size: " + this.size() + ')';
    }
}

