/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.local;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import java.net.SocketAddress;

public final class LocalAddress
extends SocketAddress
implements Comparable<LocalAddress> {
    private static final long serialVersionUID = 4644331421130916435L;
    public static final LocalAddress ANY = new LocalAddress("ANY");
    private final String id;
    private final String strVal;

    LocalAddress(Channel channel) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("local:E");
        stringBuilder.append(Long.toHexString((long)channel.hashCode() & 0xFFFFFFFFL | 0x100000000L));
        stringBuilder.setCharAt(7, ':');
        this.id = stringBuilder.substring(6);
        this.strVal = stringBuilder.toString();
    }

    public LocalAddress(String string) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        if ((string = string.trim().toLowerCase()).isEmpty()) {
            throw new IllegalArgumentException("empty id");
        }
        this.id = string;
        this.strVal = "local:" + string;
    }

    public final String id() {
        return this.id;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof LocalAddress)) {
            return false;
        }
        return this.id.equals(((LocalAddress)object).id);
    }

    @Override
    public final int compareTo(LocalAddress localAddress) {
        return this.id.compareTo(localAddress.id);
    }

    public final String toString() {
        return this.strVal;
    }
}

