/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.local;

import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.ChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.SingleThreadEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalAddress;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$3;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$4;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$5;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel$LocalUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannelRegistry;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalServerChannel;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LocalChannel
extends AbstractChannel {
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER;
    private static final ChannelMetadata METADATA;
    private static final int MAX_READER_STACK_DEPTH = 8;
    private static final ClosedChannelException DO_WRITE_CLOSED_CHANNEL_EXCEPTION;
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readTask = new LocalChannel$1(this);
    private final Runnable shutdownHook = new LocalChannel$2(this);
    private volatile int state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;
    private volatile boolean registerInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;

    public LocalChannel() {
        super(null);
    }

    LocalChannel(LocalServerChannel localServerChannel, LocalChannel localChannel) {
        super(localServerChannel);
        this.peer = localChannel;
        this.localAddress = localServerChannel.localAddress();
        this.remoteAddress = localChannel.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state < 3;
    }

    @Override
    public boolean isActive() {
        return this.state == 2;
    }

    @Override
    public AbstractChannel$AbstractUnsafe newUnsafe() {
        return new LocalChannel$LocalUnsafe(this, null);
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    public SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    @Override
    public void doRegister() {
        if (this.peer != null && this.parent() != null) {
            LocalChannel localChannel = this.peer;
            this.registerInProgress = true;
            this.state = 2;
            localChannel.remoteAddress = this.parent().localAddress();
            localChannel.state = 2;
            localChannel.eventLoop().execute(new LocalChannel$3(this, localChannel));
        }
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = 1;
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public void doClose() {
        LocalChannel localChannel = this.peer;
        if (this.state <= 2) {
            if (this.localAddress != null) {
                if (this.parent() == null) {
                    LocalChannelRegistry.unregister(this.localAddress);
                }
                this.localAddress = null;
            }
            this.state = 3;
            ChannelPromise channelPromise = this.connectPromise;
            if (channelPromise != null) {
                channelPromise.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
                this.connectPromise = null;
            }
            if (this.writeInProgress && localChannel != null) {
                this.finishPeerRead(localChannel);
            }
        }
        if (localChannel != null && localChannel.isActive()) {
            if (localChannel.eventLoop().inEventLoop() && !this.registerInProgress) {
                LocalChannel localChannel2 = localChannel;
                this.doPeerClose(localChannel2, localChannel2.writeInProgress);
            } else {
                boolean bl = localChannel.writeInProgress;
                try {
                    localChannel.eventLoop().execute(new LocalChannel$4(this, localChannel, bl));
                }
                catch (RuntimeException runtimeException) {
                    this.releaseInboundBuffers();
                    throw runtimeException;
                }
            }
            this.peer = null;
        }
    }

    private void doPeerClose(LocalChannel localChannel, boolean bl) {
        if (bl) {
            LocalChannel localChannel2 = this;
            localChannel2.finishPeerRead0(localChannel2);
        }
        localChannel.unsafe().close(localChannel.unsafe().voidPromise());
    }

    @Override
    public void doDeregister() {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    @Override
    public void doBeginRead() {
        if (this.readInProgress) {
            return;
        }
        ChannelPipeline channelPipeline = this.pipeline();
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        Integer n2 = internalThreadLocalMap.localChannelReaderStackDepth();
        if (n2 < 8) {
            internalThreadLocalMap.setLocalChannelReaderStackDepth(n2 + 1);
            try {
                Object object;
                while ((object = queue.poll()) != null) {
                    channelPipeline.fireChannelRead(object);
                }
                channelPipeline.fireChannelReadComplete();
            }
            finally {
                internalThreadLocalMap.setLocalChannelReaderStackDepth(n2);
            }
        } else {
            try {
                this.eventLoop().execute(this.readTask);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.releaseInboundBuffers();
                throw runtimeException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        if (this.state < 2) {
            throw new NotYetConnectedException();
        }
        if (this.state > 2) {
            throw DO_WRITE_CLOSED_CHANNEL_EXCEPTION;
        }
        LocalChannel localChannel = this.peer;
        this.writeInProgress = true;
        try {
            Object object;
            while ((object = channelOutboundBuffer.current()) != null) {
                try {
                    if (localChannel.state == 2) {
                        localChannel.inboundBuffer.add(ReferenceCountUtil.retain(object));
                        channelOutboundBuffer.remove();
                        continue;
                    }
                    channelOutboundBuffer.remove(DO_WRITE_CLOSED_CHANNEL_EXCEPTION);
                }
                catch (Throwable throwable) {
                    channelOutboundBuffer.remove(throwable);
                }
            }
        }
        finally {
            this.writeInProgress = false;
        }
        this.finishPeerRead(localChannel);
    }

    private void finishPeerRead(LocalChannel localChannel) {
        if (localChannel.eventLoop() == this.eventLoop() && !localChannel.writeInProgress) {
            this.finishPeerRead0(localChannel);
            return;
        }
        this.runFinishPeerReadTask(localChannel);
    }

    private void runFinishPeerReadTask(LocalChannel localChannel) {
        LocalChannel$5 localChannel$5 = new LocalChannel$5(this, localChannel);
        try {
            if (!localChannel.writeInProgress) {
                localChannel.eventLoop().execute(localChannel$5);
                return;
            }
            localChannel.finishReadFuture = localChannel.eventLoop().submit(localChannel$5);
        }
        catch (RuntimeException runtimeException) {
            localChannel.releaseInboundBuffers();
            throw runtimeException;
        }
    }

    private void releaseInboundBuffers() {
        Object object;
        while ((object = this.inboundBuffer.poll()) != null) {
            ReferenceCountUtil.release(object);
        }
    }

    private void finishPeerRead0(LocalChannel localChannel) {
        Future<?> future = localChannel.finishReadFuture;
        if (future != null) {
            if (!future.isDone()) {
                this.runFinishPeerReadTask(localChannel);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(localChannel, future, null);
        }
        future = localChannel.pipeline();
        if (localChannel.readInProgress) {
            Object object;
            localChannel.readInProgress = false;
            while ((object = localChannel.inboundBuffer.poll()) != null) {
                future.fireChannelRead(object);
            }
            future.fireChannelReadComplete();
        }
    }

    static /* synthetic */ Queue access$000(LocalChannel localChannel) {
        return localChannel.inboundBuffer;
    }

    static /* synthetic */ boolean access$202(LocalChannel localChannel, boolean bl) {
        localChannel.registerInProgress = bl;
        return localChannel.registerInProgress;
    }

    static /* synthetic */ ChannelPromise access$300(LocalChannel localChannel) {
        return localChannel.connectPromise;
    }

    static /* synthetic */ void access$400(LocalChannel localChannel, LocalChannel localChannel2, boolean bl) {
        localChannel.doPeerClose(localChannel2, bl);
    }

    static /* synthetic */ void access$500(LocalChannel localChannel, LocalChannel localChannel2) {
        localChannel.finishPeerRead0(localChannel2);
    }

    static /* synthetic */ int access$600(LocalChannel localChannel) {
        return localChannel.state;
    }

    static /* synthetic */ ChannelPromise access$302(LocalChannel localChannel, ChannelPromise channelPromise) {
        localChannel.connectPromise = channelPromise;
        return localChannel.connectPromise;
    }

    static /* synthetic */ LocalChannel access$702(LocalChannel localChannel, LocalChannel localChannel2) {
        localChannel.peer = localChannel2;
        return localChannel.peer;
    }

    static {
        METADATA = new ChannelMetadata(false);
        DO_WRITE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), LocalChannel.class, "doWrite(...)");
        DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), LocalChannel.class, "doClose()");
        AtomicReferenceFieldUpdater<LocalChannel, Object> atomicReferenceFieldUpdater = PlatformDependent.newAtomicReferenceFieldUpdater(LocalChannel.class, "finishReadFuture");
        if (atomicReferenceFieldUpdater == null) {
            atomicReferenceFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
        }
        FINISH_READ_FUTURE_UPDATER = atomicReferenceFieldUpdater;
    }
}

