/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.local;

import com.aliyun.openservices.shade.io.netty.channel.AbstractServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.SingleThreadEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalAddress;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannel;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalChannelRegistry;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalServerChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.local.LocalServerChannel$2;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

public class LocalServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
    private final Runnable shutdownHook = new LocalServerChannel$1(this);
    private volatile int state;
    private volatile LocalAddress localAddress;
    private volatile boolean acceptInProgress;

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    public SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    public void doRegister() {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = 1;
    }

    @Override
    public void doClose() {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                LocalChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    @Override
    public void doDeregister() {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    @Override
    public void doBeginRead() {
        Object object;
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        ChannelPipeline channelPipeline = this.pipeline();
        while ((object = queue.poll()) != null) {
            channelPipeline.fireChannelRead(object);
        }
        channelPipeline.fireChannelReadComplete();
    }

    LocalChannel serve(LocalChannel localChannel) {
        localChannel = new LocalChannel(this, localChannel);
        if (this.eventLoop().inEventLoop()) {
            this.serve0(localChannel);
        } else {
            this.eventLoop().execute(new LocalServerChannel$2(this, localChannel));
        }
        return localChannel;
    }

    private void serve0(LocalChannel object) {
        this.inboundBuffer.add(object);
        if (this.acceptInProgress) {
            Object object2;
            this.acceptInProgress = false;
            object = this.pipeline();
            while ((object2 = this.inboundBuffer.poll()) != null) {
                object.fireChannelRead(object2);
            }
            object.fireChannelReadComplete();
        }
    }

    static /* synthetic */ void access$000(LocalServerChannel localServerChannel, LocalChannel localChannel) {
        localServerChannel.serve0(localChannel);
    }
}

