/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractNioChannel.class, "doClose()");
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    private volatile boolean inputShutdown;
    private volatile boolean readPending;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = n2;
        try {
            selectableChannel.configureBlocking(false);
            return;
        }
        catch (IOException iOException) {
            block4: {
                try {
                    selectableChannel.close();
                }
                catch (IOException iOException2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to close a partially initialized socket.", iOException2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public AbstractNioChannel$NioUnsafe unsafe() {
        return (AbstractNioChannel$NioUnsafe)super.unsafe();
    }

    public SelectableChannel javaChannel() {
        return this.ch;
    }

    @Override
    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    protected boolean isReadPending() {
        return this.readPending;
    }

    public void setReadPending(boolean bl) {
        this.readPending = bl;
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    void setInputShutdown() {
        this.inputShutdown = true;
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof NioEventLoop;
    }

    @Override
    public void doRegister() {
        boolean bl = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().selector, 0, this);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl) {
                    this.eventLoop().selectNow();
                    bl = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    @Override
    public void doDeregister() {
        this.eventLoop().cancel(this.selectionKey());
    }

    @Override
    public void doBeginRead() {
        if (this.inputShutdown) {
            return;
        }
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int n2 = selectionKey.interestOps();
        if ((n2 & this.readInterestOp) == 0) {
            selectionKey.interestOps(n2 | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2);

    protected abstract void doFinishConnect();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        Object object = this.alloc();
        if (object.isDirectBufferPooled()) {
            object = object.directBuffer(n2);
            ByteBuf byteBuf2 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return object;
        }
        object = ByteBufUtil.threadLocalDirectBuffer();
        if (object != null) {
            ByteBuf byteBuf3 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return object;
        }
        return byteBuf;
    }

    protected final ByteBuf newDirectBuffer(ReferenceCounted referenceCounted, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
            return Unpooled.EMPTY_BUFFER;
        }
        Object object = this.alloc();
        if (object.isDirectBufferPooled()) {
            object = object.directBuffer(n2);
            ByteBuf byteBuf2 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return object;
        }
        object = ByteBufUtil.threadLocalDirectBuffer();
        if (object != null) {
            ByteBuf byteBuf3 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return object;
        }
        if (referenceCounted != byteBuf) {
            byteBuf.retain();
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
        return byteBuf;
    }

    @Override
    public void doClose() {
        Future<Void> future = this.connectPromise;
        if (future != null) {
            future.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    static /* synthetic */ ChannelPromise access$000(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$002(AbstractNioChannel abstractNioChannel, ChannelPromise channelPromise) {
        abstractNioChannel.connectPromise = channelPromise;
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$102(AbstractNioChannel abstractNioChannel, SocketAddress socketAddress) {
        abstractNioChannel.requestedRemoteAddress = socketAddress;
        return abstractNioChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$202(AbstractNioChannel abstractNioChannel, ScheduledFuture scheduledFuture) {
        abstractNioChannel.connectTimeoutFuture = scheduledFuture;
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$200(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$100(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.requestedRemoteAddress;
    }
}

