/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.nio;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopException;
import com.aliyun.openservices.shade.io.netty.channel.SelectStrategy;
import com.aliyun.openservices.shade.io.netty.channel.SingleThreadEventLoop;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$1;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$2;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$3;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$4;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$5;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoop$6;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioTask;
import com.aliyun.openservices.shade.io.netty.channel.nio.SelectedSelectionKeySet;
import com.aliyun.openservices.shade.io.netty.util.IntSupplier;
import com.aliyun.openservices.shade.io.netty.util.concurrent.RejectedExecutionHandler;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean DISABLE_KEYSET_OPTIMIZATION;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new NioEventLoop$1(this);
    private final Callable<Integer> pendingTasksCallable = new NioEventLoop$2(this);
    Selector selector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup nioEventLoopGroup, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super(nioEventLoopGroup, threadFactory, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        if (selectorProvider == null) {
            throw new NullPointerException("selectorProvider");
        }
        if (selectStrategy == null) {
            throw new NullPointerException("selectStrategy");
        }
        this.provider = selectorProvider;
        this.selector = this.openSelector();
        this.selectStrategy = selectStrategy;
    }

    private Selector openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEYSET_OPTIMIZATION) {
            return abstractSelector;
        }
        Object object = new SelectedSelectionKeySet();
        Object object2 = AccessController.doPrivileged(new NioEventLoop$4(this));
        if (!(object2 instanceof Class) || !((Class)object2).isAssignableFrom(abstractSelector.getClass())) {
            if (object2 instanceof Exception) {
                object2 = (Exception)object2;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, object2);
            }
            return abstractSelector;
        }
        object2 = (Class)object2;
        if ((object2 = AccessController.doPrivileged(new NioEventLoop$5(this, (Class)object2, abstractSelector, (SelectedSelectionKeySet)object))) instanceof Exception) {
            this.selectedKeys = null;
            object = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, object);
        } else {
            this.selectedKeys = object;
            logger.trace("instrumented a special java.util.Set into: {}", (Object)abstractSelector);
        }
        return abstractSelector;
    }

    public final SelectorProvider selectorProvider() {
        return this.provider;
    }

    @Override
    public final Queue<Runnable> newTaskQueue(int n2) {
        return PlatformDependent.newMpscQueue(n2);
    }

    @Override
    public final int pendingTasks() {
        if (this.inEventLoop()) {
            return super.pendingTasks();
        }
        NioEventLoop nioEventLoop = this;
        return (Integer)nioEventLoop.submit(nioEventLoop.pendingTasksCallable).syncUninterruptibly().getNow();
    }

    public final void register(SelectableChannel selectableChannel, int n2, NioTask<?> nioTask) {
        if (selectableChannel == null) {
            throw new NullPointerException("ch");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((n2 & ~selectableChannel.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + n2 + "(validOps: " + selectableChannel.validOps() + ')');
        }
        if (nioTask == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        try {
            selectableChannel.register(this.selector, n2, nioTask);
            return;
        }
        catch (Exception exception) {
            throw new EventLoopException("failed to register a channel", exception);
        }
    }

    public final int getIoRatio() {
        return this.ioRatio;
    }

    public final void setIoRatio(int n2) {
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n2 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n2;
    }

    public final void rebuildSelector() {
        int n2;
        block14: {
            Selector selector;
            if (!this.inEventLoop()) {
                this.execute(new NioEventLoop$6(this));
                return;
            }
            Selector selector2 = this.selector;
            if (selector2 == null) {
                return;
            }
            try {
                selector = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n2 = 0;
            while (true) {
                try {
                    for (SelectionKey selectionKey : selector2.keys()) {
                        Object object;
                        Object object2 = selectionKey.attachment();
                        try {
                            if (!selectionKey.isValid() || selectionKey.channel().keyFor(selector) != null) continue;
                            int n3 = selectionKey.interestOps();
                            selectionKey.cancel();
                            object = selectionKey.channel().register(selector, n3, object2);
                            if (object2 instanceof AbstractNioChannel) {
                                ((AbstractNioChannel)object2).selectionKey = object;
                            }
                            ++n2;
                        }
                        catch (Exception exception) {
                            logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                            if (object2 instanceof AbstractNioChannel) {
                                object = (AbstractNioChannel)object2;
                                ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                                continue;
                            }
                            object = (NioTask)object2;
                            NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                        }
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
            this.selector = selector;
            try {
                selector2.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block14;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        logger.info("Migrated " + n2 + " channel(s) to the new Selector.");
    }

    @Override
    public final void run() {
        while (true) {
            Throwable throwable;
            block17: {
                try {
                    block15: while (true) {
                        switch (this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks())) {
                            case -2: {
                                continue block15;
                            }
                            case -1: {
                                NioEventLoop nioEventLoop = this;
                                nioEventLoop.select(nioEventLoop.wakenUp.getAndSet(false));
                                if (!this.wakenUp.get()) break block15;
                                this.selector.wakeup();
                            }
                        }
                        break;
                    }
                    this.cancelledKeys = 0;
                    this.needsToSelectAgain = false;
                    int n2 = this.ioRatio;
                    if (n2 == 100) {
                        try {
                            this.processSelectedKeys();
                            break block17;
                        }
                        finally {
                            this.runAllTasks();
                        }
                    }
                    long l2 = System.nanoTime();
                    try {
                        this.processSelectedKeys();
                    }
                    finally {
                        long l3 = System.nanoTime() - l2;
                        this.runAllTasks(l3 * (long)(100 - n2) / (long)n2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    NioEventLoop.handleLoopException(throwable2);
                }
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
                return;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                NioEventLoop.handleLoopException(throwable3);
                continue;
            }
            break;
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            NioEventLoop nioEventLoop = this;
            nioEventLoop.processSelectedKeysOptimized(nioEventLoop.selectedKeys.flip());
            return;
        }
        NioEventLoop nioEventLoop = this;
        nioEventLoop.processSelectedKeysPlain(nioEventLoop.selector.selectedKeys());
    }

    @Override
    public final void cleanup() {
        try {
            this.selector.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
            return;
        }
    }

    final void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    @Override
    public final Runnable pollTask() {
        Runnable runnable = super.pollTask();
        if (this.needsToSelectAgain) {
            this.selectAgain();
        }
        return runnable;
    }

    private void processSelectedKeysPlain(Set<SelectionKey> object) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (true) {
            SelectionKey selectionKey = (SelectionKey)object.next();
            Object object2 = selectionKey.attachment();
            object.remove();
            if (object2 instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object2);
            } else {
                object2 = (NioTask)object2;
                NioEventLoop.processSelectedKey(selectionKey, (NioTask<SelectableChannel>)object2);
            }
            if (!object.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            object = this.selector.selectedKeys();
            if (object.isEmpty()) break;
            object = object.iterator();
        }
    }

    private void processSelectedKeysOptimized(SelectionKey[] selectionKeyArray) {
        SelectionKey selectionKey;
        int n2 = 0;
        while ((selectionKey = selectionKeyArray[n2]) != null) {
            selectionKeyArray[n2] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                object = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, (NioTask<SelectableChannel>)object);
            }
            if (this.needsToSelectAgain) {
                while (selectionKeyArray[++n2] != null) {
                    selectionKeyArray[n2] = null;
                }
                this.selectAgain();
                selectionKeyArray = this.selectedKeys.flip();
                n2 = -1;
            }
            ++n2;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop != this || nioEventLoop == null) {
                return;
            }
            AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe2 = abstractNioChannel$NioUnsafe;
            abstractNioChannel$NioUnsafe2.close(abstractNioChannel$NioUnsafe2.voidPromise());
            return;
        }
        try {
            int n2 = selectionKey.readyOps();
            if ((n2 & 8) != 0) {
                int n3 = selectionKey.interestOps();
                selectionKey.interestOps(n3 &= 0xFFFFFFF7);
                abstractNioChannel$NioUnsafe.finishConnect();
            }
            if ((n2 & 4) != 0) {
                abstractNioChannel.unsafe().forceFlush();
            }
            if ((n2 & 0x11) != 0 || n2 == 0) {
                abstractNioChannel$NioUnsafe.read();
                if (!abstractNioChannel.isOpen()) {
                    return;
                }
            }
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe3 = abstractNioChannel$NioUnsafe;
            abstractNioChannel$NioUnsafe3.close(abstractNioChannel$NioUnsafe3.voidPromise());
            return;
        }
    }

    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        block4: {
            try {
                nioTask.channelReady(selectionKey.channel(), selectionKey);
                if (selectionKey.isValid()) break block4;
            }
            catch (Exception exception) {
                try {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
                    return;
                }
                catch (Throwable throwable) {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    throw throwable;
                }
            }
            NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
        }
        return;
    }

    private void closeAll() {
        this.selectAgain();
        Iterator iterator = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SelectionKey object = (SelectionKey)iterator.next();
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            object2 = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object2, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
            return;
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
            return;
        }
    }

    @Override
    public final void wakeup(boolean bl) {
        if (!bl && this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    final int selectNow() {
        try {
            int n2 = this.selector.selectNow();
            return n2;
        }
        finally {
            if (this.wakenUp.get()) {
                this.selector.wakeup();
            }
        }
    }

    private void select(boolean bl) {
        Selector selector = this.selector;
        try {
            int n2 = 0;
            long l2 = System.nanoTime();
            long l3 = l2 + this.delayNanos(l2);
            while (true) {
                long l4;
                if ((l4 = (l3 - l2 + 500000L) / 1000000L) <= 0L) {
                    if (n2 != 0) break;
                    selector.selectNow();
                    n2 = 1;
                    break;
                }
                if (this.hasTasks() && this.wakenUp.compareAndSet(false, true)) {
                    selector.selectNow();
                    n2 = 1;
                    break;
                }
                int n3 = selector.select(l4);
                ++n2;
                if (n3 != 0 || bl || this.wakenUp.get() || this.hasTasks() || this.hasScheduledTasks()) break;
                if (Thread.interrupted()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
                    }
                    n2 = 1;
                    break;
                }
                long l5 = System.nanoTime();
                if (l5 - TimeUnit.MILLISECONDS.toNanos(l4) >= l2) {
                    n2 = 1;
                } else if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n2 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
                    logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n2, (Object)selector);
                    this.rebuildSelector();
                    selector = this.selector;
                    selector.selectNow();
                    n2 = 1;
                    break;
                }
                l2 = l5;
            }
            if (n2 > 3 && logger.isDebugEnabled()) {
                logger.debug("Selector.select() returned prematurely {} times in a row for Selector {}.", (Object)(n2 - 1), (Object)selector);
            }
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            if (logger.isDebugEnabled()) {
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector {} - JDK bug?", (Object)selector, (Object)cancelledKeyException);
            }
            return;
        }
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
            return;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
            return;
        }
    }

    static /* synthetic */ int access$001(NioEventLoop nioEventLoop) {
        return super.pendingTasks();
    }

    static {
        int n2;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEYSET_OPTIMIZATION = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noKeySetOptimization", false);
        String string = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
        if (string == null) {
            try {
                AccessController.doPrivileged(new NioEventLoop$3());
            }
            catch (SecurityException securityException) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
            }
        }
        if ((n2 = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n2 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEYSET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }
}

