/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.oio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.oio.AbstractOioChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.ChannelInputShutdownEvent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private RecvByteBufAllocator$Handle allocHandle;
    private volatile boolean inputShutdown;

    protected AbstractOioByteChannel(Channel channel) {
        super(channel);
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected boolean checkInputShutdown() {
        if (this.inputShutdown) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    @Override
    protected void doRead() {
        int n2;
        boolean bl;
        ChannelPipeline channelPipeline;
        block38: {
            ByteBuf byteBuf;
            block37: {
                if (this.checkInputShutdown()) {
                    return;
                }
                Object object = this.config();
                channelPipeline = this.pipeline();
                RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.allocHandle;
                if (recvByteBufAllocator$Handle == null) {
                    this.allocHandle = recvByteBufAllocator$Handle = object.getRecvByteBufAllocator().newHandle();
                }
                byteBuf = recvByteBufAllocator$Handle.allocate(this.alloc());
                bl = false;
                boolean bl2 = false;
                n2 = 0;
                try {
                    int n3 = 0;
                    do {
                        if ((n2 = this.doReadBytes(byteBuf)) > 0) {
                            bl2 = true;
                        } else if (n2 < 0) {
                            bl = true;
                        }
                        int n4 = this.available();
                        if (n4 <= 0) break;
                        if (!byteBuf.isWritable()) {
                            int n5;
                            int n6 = byteBuf.capacity();
                            if (n6 == (n5 = byteBuf.maxCapacity())) {
                                if (bl2) {
                                    bl2 = false;
                                    channelPipeline.fireChannelRead(byteBuf);
                                    byteBuf = this.alloc().buffer();
                                }
                            } else {
                                n6 = byteBuf.writerIndex();
                                if (n6 + n4 > n5) {
                                    byteBuf.capacity(n5);
                                } else {
                                    byteBuf.ensureWritable(n4);
                                }
                            }
                        }
                        if (n3 >= Integer.MAX_VALUE - n2) {
                            n3 = Integer.MAX_VALUE;
                            break;
                        }
                        n3 += n2;
                    } while (object.isAutoRead());
                    recvByteBufAllocator$Handle.record(n3);
                    if (!bl2) break block37;
                    channelPipeline.fireChannelRead(byteBuf);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    if (bl2) {
                        channelPipeline.fireChannelRead(byteBuf);
                    } else {
                        byteBuf.release();
                    }
                    channelPipeline.fireChannelReadComplete();
                    if (object instanceof IOException) {
                        bl = true;
                        this.pipeline().fireExceptionCaught((Throwable)object);
                    } else {
                        channelPipeline.fireExceptionCaught((Throwable)object);
                        this.unsafe().close(this.voidPromise());
                    }
                    if (bl) {
                        this.inputShutdown = true;
                        if (this.isOpen()) {
                            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                            } else {
                                this.unsafe().close(this.unsafe().voidPromise());
                            }
                        }
                    }
                    if (n2 == 0 && this.isActive()) {
                        this.read();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        channelPipeline.fireChannelRead(byteBuf);
                    } else {
                        byteBuf.release();
                    }
                    channelPipeline.fireChannelReadComplete();
                    if (bl) {
                        this.inputShutdown = true;
                        if (this.isOpen()) {
                            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                            } else {
                                this.unsafe().close(this.unsafe().voidPromise());
                            }
                        }
                    }
                    if (n2 == 0 && this.isActive()) {
                        this.read();
                    }
                    throw throwable;
                }
                break block38;
            }
            byteBuf.release();
        }
        channelPipeline.fireChannelReadComplete();
        if (bl) {
            this.inputShutdown = true;
            if (this.isOpen()) {
                if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                    channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.unsafe().close(this.unsafe().voidPromise());
                }
            }
        }
        if (n2 == 0 && this.isActive()) {
            this.read();
            return;
        }
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            if (object instanceof ByteBuf) {
                object = (ByteBuf)object;
                int n2 = ((ByteBuf)object).readableBytes();
                while (n2 > 0) {
                    this.doWriteBytes((ByteBuf)object);
                    int n3 = ((ByteBuf)object).readableBytes();
                    channelOutboundBuffer.progress(n2 - n3);
                    n2 = n3;
                }
                channelOutboundBuffer.remove();
                continue;
            }
            if (object instanceof FileRegion) {
                object = (FileRegion)object;
                long l2 = object.transfered();
                this.doWriteFileRegion((FileRegion)object);
                channelOutboundBuffer.progress(object.transfered() - l2);
                channelOutboundBuffer.remove();
                continue;
            }
            channelOutboundBuffer.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object)));
        }
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf || object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract void doWriteBytes(ByteBuf var1);

    protected abstract void doWriteFileRegion(FileRegion var1);
}

