/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.pool;

import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelPool;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelPoolMap;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ReadOnlyIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Closeable,
Iterable<Map.Entry<K, P>> {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    @Override
    public final P get(K object) {
        ChannelPool channelPool = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(object, "key"));
        if (channelPool == null && (object = this.map.putIfAbsent(object, channelPool = this.newPool(object))) != null) {
            channelPool.close();
            channelPool = object;
        }
        return (P)channelPool;
    }

    public final boolean remove(K object) {
        if ((object = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(object, "key"))) != null) {
            object.close();
            return true;
        }
        return false;
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator<Map.Entry<K, P>>(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean contains(K k2) {
        return this.map.containsKey(ObjectUtil.checkNotNull(k2, "key"));
    }

    protected abstract P newPool(K var1);

    @Override
    public final void close() {
        for (Object k2 : this.map.keySet()) {
            this.remove(k2);
        }
    }
}

