/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.pool;

import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelHealthChecker;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelPoolHandler;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$1;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$2;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$3;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$4;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$5;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$AcquireListener;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$AcquireTask;
import com.aliyun.openservices.shade.io.netty.channel.pool.FixedChannelPool$AcquireTimeoutAction;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericFutureListener;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FixedChannelPool
extends SimpleChannelPool {
    private static final IllegalStateException FULL_EXCEPTION = ThrowableUtil.unknownStackTrace(new IllegalStateException("Too many outstanding acquire operations"), FixedChannelPool.class, "acquire0(...)");
    private static final TimeoutException TIMEOUT_EXCEPTION = ThrowableUtil.unknownStackTrace(new TimeoutException("Acquire operation took longer then configured maximum time"), FixedChannelPool.class, "<init>(...)");
    private final EventExecutor executor;
    private final long acquireTimeoutNanos;
    private final Runnable timeoutTask;
    private final Queue<FixedChannelPool$AcquireTask> pendingAcquireQueue = new ArrayDeque<FixedChannelPool$AcquireTask>();
    private final int maxConnections;
    private final int maxPendingAcquires;
    private int acquiredChannelCount;
    private int pendingAcquireCount;
    private boolean closed;

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n2) {
        this(bootstrap, channelPoolHandler, n2, Integer.MAX_VALUE);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n2, int n3) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE, null, -1L, n2, n3);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, FixedChannelPool$AcquireTimeoutAction fixedChannelPool$AcquireTimeoutAction, long l2, int n2, int n3) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, fixedChannelPool$AcquireTimeoutAction, l2, n2, n3, true);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, FixedChannelPool$AcquireTimeoutAction fixedChannelPool$AcquireTimeoutAction, long l2, int n2, int n3, boolean bl) {
        super(bootstrap, channelPoolHandler, channelHealthChecker, bl);
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxConnections: " + n2 + " (expected: >= 1)");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxPendingAcquires: " + n3 + " (expected: >= 1)");
        }
        if (fixedChannelPool$AcquireTimeoutAction == null && l2 == -1L) {
            this.timeoutTask = null;
            this.acquireTimeoutNanos = -1L;
        } else {
            if (fixedChannelPool$AcquireTimeoutAction == null && l2 != -1L) {
                throw new NullPointerException("action");
            }
            if (fixedChannelPool$AcquireTimeoutAction != null && l2 < 0L) {
                throw new IllegalArgumentException("acquireTimeoutMillis: " + l2 + " (expected: >= 1)");
            }
            this.acquireTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(l2);
            switch (fixedChannelPool$AcquireTimeoutAction) {
                case FAIL: {
                    this.timeoutTask = new FixedChannelPool$1(this);
                    break;
                }
                case NEW: {
                    this.timeoutTask = new FixedChannelPool$2(this);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        this.executor = bootstrap.group().next();
        this.maxConnections = n2;
        this.maxPendingAcquires = n3;
    }

    @Override
    public final Future<Channel> acquire(Promise<Channel> promise) {
        try {
            if (this.executor.inEventLoop()) {
                this.acquire0(promise);
            } else {
                this.executor.execute(new FixedChannelPool$3(this, promise));
            }
        }
        catch (Throwable throwable) {
            promise.setFailure(throwable);
        }
        return promise;
    }

    private void acquire0(Promise<Channel> object) {
        assert (this.executor.inEventLoop());
        if (this.closed) {
            object.setFailure(new IllegalStateException("FixedChannelPooled was closed"));
            return;
        }
        if (this.acquiredChannelCount < this.maxConnections) {
            assert (this.acquiredChannelCount >= 0);
            Promise<Channel> promise = this.executor.newPromise();
            object = new FixedChannelPool$AcquireListener(this, (Promise<Channel>)object);
            ((FixedChannelPool$AcquireListener)object).acquired();
            promise.addListener((GenericFutureListener<Future<Channel>>)object);
            super.acquire(promise);
            return;
        }
        if (this.pendingAcquireCount >= this.maxPendingAcquires) {
            object.setFailure(FULL_EXCEPTION);
        } else {
            FixedChannelPool$AcquireTask fixedChannelPool$AcquireTask = new FixedChannelPool$AcquireTask(this, (Promise<Channel>)object);
            if (this.pendingAcquireQueue.offer(fixedChannelPool$AcquireTask)) {
                ++this.pendingAcquireCount;
                if (this.timeoutTask != null) {
                    fixedChannelPool$AcquireTask.timeoutFuture = this.executor.schedule(this.timeoutTask, this.acquireTimeoutNanos, TimeUnit.NANOSECONDS);
                }
            } else {
                object.setFailure(FULL_EXCEPTION);
            }
        }
        assert (this.pendingAcquireCount > 0);
    }

    @Override
    public final Future<Void> release(Channel channel, Promise<Void> promise) {
        Promise<Void> promise2 = this.executor.newPromise();
        super.release(channel, promise2.addListener(new FixedChannelPool$4(this, promise)));
        return promise2;
    }

    private void decrementAndRunTaskQueue() {
        --this.acquiredChannelCount;
        assert (this.acquiredChannelCount >= 0);
        this.runTaskQueue();
    }

    private void runTaskQueue() {
        FixedChannelPool$AcquireTask fixedChannelPool$AcquireTask;
        while (this.acquiredChannelCount < this.maxConnections && (fixedChannelPool$AcquireTask = this.pendingAcquireQueue.poll()) != null) {
            ScheduledFuture<?> scheduledFuture = fixedChannelPool$AcquireTask.timeoutFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            --this.pendingAcquireCount;
            fixedChannelPool$AcquireTask.acquired();
            super.acquire(fixedChannelPool$AcquireTask.promise);
        }
        assert (this.pendingAcquireCount >= 0);
        assert (this.acquiredChannelCount >= 0);
    }

    @Override
    public final void close() {
        this.executor.execute(new FixedChannelPool$5(this));
    }

    static /* synthetic */ TimeoutException access$100() {
        return TIMEOUT_EXCEPTION;
    }

    static /* synthetic */ Future access$201(FixedChannelPool fixedChannelPool, Promise promise) {
        return super.acquire(promise);
    }

    static /* synthetic */ void access$300(FixedChannelPool fixedChannelPool, Promise promise) {
        fixedChannelPool.acquire0(promise);
    }

    static /* synthetic */ EventExecutor access$400(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.executor;
    }

    static /* synthetic */ boolean access$500(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.closed;
    }

    static /* synthetic */ void access$600(FixedChannelPool fixedChannelPool) {
        fixedChannelPool.decrementAndRunTaskQueue();
    }

    static /* synthetic */ long access$700(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.acquireTimeoutNanos;
    }

    static /* synthetic */ Queue access$800(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.pendingAcquireQueue;
    }

    static /* synthetic */ int access$906(FixedChannelPool fixedChannelPool) {
        return --fixedChannelPool.pendingAcquireCount;
    }

    static /* synthetic */ void access$1000(FixedChannelPool fixedChannelPool) {
        fixedChannelPool.runTaskQueue();
    }

    static /* synthetic */ int access$1108(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.acquiredChannelCount++;
    }

    static /* synthetic */ boolean access$502(FixedChannelPool fixedChannelPool, boolean bl) {
        fixedChannelPool.closed = bl;
        return fixedChannelPool.closed;
    }

    static /* synthetic */ int access$1102(FixedChannelPool fixedChannelPool, int n2) {
        fixedChannelPool.acquiredChannelCount = n2;
        return fixedChannelPool.acquiredChannelCount;
    }

    static /* synthetic */ int access$902(FixedChannelPool fixedChannelPool, int n2) {
        fixedChannelPool.pendingAcquireCount = n2;
        return fixedChannelPool.pendingAcquireCount;
    }

    static /* synthetic */ void access$1201(FixedChannelPool fixedChannelPool) {
        super.close();
    }
}

